<?php
// Iniciar sessão para gerenciar autenticação
session_start();

// Verificar se já está autenticado ou se o formulário foi enviado
$authenticated = false;
$error = false;

if (isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true) {
    $authenticated = true;
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    // Aqui qualquer senha será aceita
    if (strlen($_POST['password']) > 0) {
        $_SESSION['authenticated'] = true;
        $authenticated = true;
    } else {
        $error = true;
    }
}

// Array com informações dos suspeitos
$suspects = [
    'bethany' => [
        'nome' => 'Bethany Adams',
        'imagem' => 'bethany.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Bethany Adams</strong></p>
                      <p>Motivo: Sim. Adams tinha um relacionamento pessoal com Dr. Warren e evidências sugerem que ele recentemente havia "reconciliado" com sua esposa, o que teria abalado as promessas feitas a Adams.</p>
                      <p>Oportunidade: Não. Adams foi a última pessoa confirmada a ver Dr. Warren com vida, mas não há provas de que ela tenha retornado à clínica no momento do crime.</p>
                      <p>Meios: Talvez. Foi detectada a presença de Z-97 em uma amostra de perfume encontrada na bolsa de Bethany, porém ela alega que o perfume foi um presente do próprio Dr. Warren.</p>'
    ],
    'richard' => [
        'nome' => 'Richard Miller',
        'imagem' => 'richard.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Richard Miller</strong></p>
                      <p>Motivo: Sim. Richard estava furioso porque Dr. Warren estava usando suas experiências traumáticas pessoais sem autorização adequada em um livro.</p>
                      <p>Oportunidade: Nãp. O álibi de Miller é frágil, apoiado apenas por uma declaração escrita de sua namorada, porém não há provas de que ele tenha ido na clínica ou mentido sobre isso.</p>
                      <p>Meios: Sim. Como paciente familiarizado com os tratamentos experimentais, Miller era um dos "voluntários" no programa Z-97 e teria conhecimento sobre a substância.</p>'
    ],
    'lucas' => [
        'nome' => 'Dr. Lucas Mitchell',
        'imagem' => 'lucas.jpeg',
        'culpado' => true,
        'solucao' => '<div class="solucao-completa">
                      <h2>SOLUÇÃO COMPLETA</h2>
                      <p>Abaixo está uma explicação detalhada da solução do caso.</p>
                      
                      <p><strong>Dr. Lucas Mitchell</strong><br>
                      Motivo: SIM. Mitchell tinha um conflito acadêmico sério com Dr. Warren, envolvendo acusações de plágio e disputas sobre atribuição de crédito em pesquisas. Ele enviou um email intitulado "Última Chance" dois dias antes do crime, demonstrando frustração após meses tentando resolver a situação.<br>
                      Oportunidade: SIM. Mitchell afirma ter estado em seu laboratório universitário das 17h às 22h, trabalhando em uma análise de dados. No entanto, existem contradições significativas em seu álibi: na foto de vigilância do laboratório datada de 12/09/2023 às 21:10, o relógio na parede claramente mostra 10:07, indicando que a imagem foi falsificada. Além disso, há uma frase em sua proposta de pesquisa ("Dentro de nossa consciência, encontramos a verdadeira natureza humana") que coincide quase exatamente com um trecho da carta de suicídio, sugerindo fortemente que Mitchell foi o autor do documento.<br>
                      Meios: SIM. Como neurocientista, Mitchell tinha acesso ao Z-97 em seu laboratório e conhecimento detalhado sobre seus efeitos. Ele próprio confirma que a substância é utilizada em seus estudos acadêmicos, tendo amplo conhecimento de suas propriedades paralisantes.</p>
                          <h3>Conclusão Final</h3>
                      <p>Dr. Lucas Mitchell é o único suspeito com motivo, oportunidade e meios verificáveis para cometer o crime. Seu álibi foi falsificado, como evidenciado pela discrepância entre a data na foto e o relógio na parede. A frase de sua proposta de pesquisa que coincide com a carta de suicídio é prova adicional de sua culpa. Como neurocientista, ele tinha acesso e conhecimento do Z-97, a substância usada para matar Dr. Warren. O conflito acadêmico forneceu um motivo forte, e ele tinha o conhecimento científico para executar o assassinato e tentar encobri-lo como suicídio.</p>
                      </div>'
    ],
    'catherine' => [
        'nome' => 'Dra. Catherine Lambert',
        'imagem' => 'catherine.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Dra. Catherine Lambert</strong></p>
                      <p>Motivo: Sim. Como sócia da clínica, Dra. Lambert tinha múltiplos motivos. Evidências mostram que ela estava enfrentando sérias dificuldades financeiras e assumiria controle total do estabelecimento em caso de falecimento do Dr. Warren.</p>
                      <p>Oportunidade: Não. Lambert alega ter estado no Hospital Central atendendo uma emergência entre 19h30 e 23h15 na noite do crime. Os registros do hospital confirmam sua presença.</p>
                      <p>Meios: Sim. Como médica psiquiatra e co-proprietária da clínica, ela tinha acesso direto ao Z-97 e conhecimento detalhado de como utilizá-lo.</p>'
    ],
    'oliver' => [
        'nome' => 'Oliver Crawford',
        'imagem' => 'oliver.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Oliver Crawford</strong></p>
                      <p>Motivo: Sim. Crawford tinha motivos financeiros e pessoais. Estava negociando financiamento para as pesquisas do Dr. Warren, mas investigações revelam conflitos sobre propriedade intelectual.</p>
                      <p>Oportunidade: Não. O álibi de Crawford é sólido. Seu cartão de embarque confirma que estava em um voo de Chicago para Ravenwood que pousou às 21h50.</p>
                      <p>Meios: Não. Apesar de seu poder e influência, não há evidências de que Crawford tivesse acesso ao Z-97 ou conhecimento sobre como utilizá-lo.</p>'
    ],
    'marcus' => [
        'nome' => 'Marcus Warren',
        'imagem' => 'marcus.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Marcus Warren</strong></p>
                      <p>Motivo: Talvez. Como irmão da vítima, Marcus tinha um forte motivo financeiro. Ele acusava Philip de ter manipulado seu pai doente para alterar o testamento.</p>
                      <p>Oportunidade: Sim. Seu álibi é fraco. Alega ter estado pescando sozinho no lago Clearwater entre 19h e 22h, uma atividade solitária sem testemunhas além do lago ser perto da clínica possibilitando ele de ter parado o barco e ido ate lá, porém não há evidências disso..</p>
                      <p>Meios: Não. Marcus não tinha acesso ao Z-97, substância controlada e experimental usada apenas no ambiente clínico.</p>'
    ],
    'annabel' => [
        'nome' => 'Annabel Chapman',
        'imagem' => 'annabel.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Annabel Chapman</strong></p>
                      <p>Motivo: Sim. Chapman culpava Dr. Warren pelo suicídio de sua filha Emily. Descobriu evidências de que ele conduzia "experimentos mentais" com a adolescente.</p>
                      <p>Oportunidade: Talvez. Chapman alega ter estado no show da Nightshade Altar no The Gasworks naquela noite, apesar do show ser perto do consultório e não ter provas que ela esteve lá durante toda a noitenão há evidências de que ela tenha ido até a clínica aquela noite. </p>
                      <p>Meios: Não. Não há qualquer evidência de que Chapman tivesse conhecimento sobre o Z-97 ou acesso a ele.</p>'
    ],
    'rebecca' => [
        'nome' => 'Rebecca Warren',
        'imagem' => 'rebecca.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Rebecca Warren</strong></p>
                      <p>Motivo: Sim. Como esposa da vítima, Rebecca tinha múltiplos motivos. Era beneficiária principal de um seguro de vida de $3,5 milhões, sairia sem nada no divórcio e descobriu múltiplas infidelidades do marido.</p>
                      <p>Oportunidade: Possível. Rebecca afirma ter estado em um spa às 19h00 e depois jantado com sua irmã, saindo do restaurante às 21h00 e indo direto para casa.</p>
                      <p>Meios: Não. Rebecca como diz no perfil do suspeito possui alergia severa a sulfitos, um dos componentes presentes no Z-97 afirmado na autópsia, tornando impossível que ela tenha manipulado a substância.</p>'
    ]
];

// Verificar se um suspeito foi selecionado
$selectedSuspect = null;
$isCorrect = false;

if ($authenticated && isset($_GET['suspect']) && array_key_exists($_GET['suspect'], $suspects)) {
    $selectedSuspect = $suspects[$_GET['suspect']];
    $isCorrect = $selectedSuspect['culpado'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caso Criminal: O Assassinato de Dr. Philip Warren</title>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Montserrat:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        :root {
            --primary: #8B0000;
            --primary-dark: #5C0000;
            --primary-light: #C41E3A;
            --primary-hover: #9D0000;
            --accent: #FFD700;
            --accent-dark: #DAA520;
            --text-light: #F5F5F5;
            --text-dark: #333333;
            --bg-dark: #1A1A1A;
            --bg-darker: #121212;
            --bg-light: #2A2A2A;
            --success: #4CAF50;
            --error: #FF5252;
            --card-shadow: rgba(0, 0, 0, 0.2);
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            --paper-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
            --paper-shadow-hover: 0 14px 28px rgba(0,0,0,0.25), 0 10px 10px rgba(0,0,0,0.22);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Montserrat', sans-serif;
            background-color: var(--bg-darker);
            color: var(--text-light);
            line-height: 1.6;
            background-image: url('https://i.imgur.com/JxqL1Qz.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.75);
            z-index: -1;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        
        header {
            text-align: center;
            margin-bottom: 40px;
            border-bottom: 2px solid var(--primary);
            padding-bottom: 20px;
        }
        
        h1 {
            font-family: 'Playfair Display', serif;
            font-size: 3.5rem;
            color: var(--primary);
            margin-bottom: 15px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }
        
        h2 {
            font-family: 'Playfair Display', serif;
            font-size: 2.2rem;
            color: var(--accent);
            margin: 25px 0;
            text-align: center;
        }
        
        h3 {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            color: var(--accent);
            margin: 20px 0;
        }
        
        .subtitle {
            font-family: 'Montserrat', sans-serif;
            font-size: 1.2rem;
            font-weight: 300;
            color: var(--text-light);
            font-style: italic;
            margin-bottom: 30px;
        }
        
        /* Formulário de senha */
        .password-form {
            max-width: 450px;
            margin: 80px auto;
            padding: 35px;
            background: rgba(26, 26, 26, 0.95);
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            border: 1px solid var(--primary);
            animation: fadeIn 1s;
        }
        
        .password-form h2 {
            margin-top: 0;
            font-size: 1.8rem;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        label {
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
            font-size: 1.1rem;
        }
        
        input[type="text"] {
            width: 100%;
            padding: 15px;
            background: var(--bg-darker);
            border: 1px solid var(--bg-light);
            border-radius: 5px;
            color: var(--text-light);
            font-size: 1.1rem;
            transition: var(--transition);
        }
        
        input[type="text"]:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 8px rgba(139, 0, 0, 0.5);
        }
        
        button {
            display: block;
            width: 100%;
            padding: 15px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1.1rem;
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        button:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        
        .error-message {
            color: var(--error);
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            background: rgba(255, 82, 82, 0.1);
            border-radius: 4px;
            font-weight: 500;
        }
        
        /* Grid de suspeitos */
        .suspects-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 25px;
            margin: 40px 0;
        }
        
        .suspect-card {
            background: rgba(42, 42, 42, 0.95);
            border-radius: 8px;
            overflow: hidden;
            transition: var(--transition);
            border: 1px solid var(--primary-dark);
            cursor: pointer;
            position: relative;
            animation: fadeInUp 0.8s;
            animation-fill-mode: both;
            box-shadow: var(--paper-shadow);
        }
        
        .suspects-grid .suspect-card:nth-child(1) { animation-delay: 0.1s; }
        .suspects-grid .suspect-card:nth-child(2) { animation-delay: 0.2s; }
        .suspects-grid .suspect-card:nth-child(3) { animation-delay: 0.3s; }
        .suspects-grid .suspect-card:nth-child(4) { animation-delay: 0.4s; }
        .suspects-grid .suspect-card:nth-child(5) { animation-delay: 0.5s; }
        .suspects-grid .suspect-card:nth-child(6) { animation-delay: 0.6s; }
        .suspects-grid .suspect-card:nth-child(7) { animation-delay: 0.7s; }
        
        .suspect-card:hover {
            transform: translateY(-10px) scale(1.02);
            box-shadow: var(--paper-shadow-hover);
            border-color: var(--primary);
        }
        
        .suspect-card::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(to bottom, transparent 70%, rgba(139, 0, 0, 0.7) 100%);
            opacity: 0;
            transition: var(--transition);
        }
        
        .suspect-card:hover::after {
            opacity: 1;
        }
        
        .suspect-card img {
            width: 100%;
            height: 300px;
            object-fit: cover;
            transition: var(--transition);
            display: block;
            filter: grayscale(30%);
        }
        
        .suspect-card:hover img {
            filter: grayscale(0%);
            transform: scale(1.05);
        }
        
        .suspect-info {
            padding: 15px;
            text-align: center;
            background: var(--primary-dark);
            position: relative;
            z-index: 2;
            transition: var(--transition);
        }
        
        .suspect-card:hover .suspect-info {
            background: var(--primary);
        }
        
        .suspect-name {
            font-family: 'Playfair Display', serif;
            font-size: 1.3rem;
            margin: 0;
            padding: 0;
            color: var(--text-light);
            position: relative;
        }
        
        .suspect-name::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 2px;
            background-color: var(--accent);
            transition: var(--transition);
        }
        
        .suspect-card:hover .suspect-name::after {
            width: 80%;
        }
        
        /* Resultado */
        .result-container {
            max-width: 900px;
            margin: 40px auto;
            padding: 40px;
            background: rgba(26, 26, 26, 0.95);
            border-radius: 10px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.5);
            animation: fadeIn 1s;
            border-left: 5px solid;
        }
        
        .result-correct {
            border-color: var(--success);
        }
        
        .result-incorrect {
            border-color: var(--error);
        }
        
        .result-header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid var(--bg-light);
        }
        
        .result-img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            margin-right: 25px;
            border: 3px solid;
        }
        
        .result-correct .result-img {
            border-color: var(--success);
        }
        
        .result-incorrect .result-img {
            border-color: var(--error);
        }
        
        .result-title {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            margin-bottom: 10px;
        }
        
        .result-subtitle {
            font-size: 1.1rem;
            font-weight: 300;
            margin-bottom: 0;
        }
        
        .verdict {
            font-family: 'Playfair Display', serif;
            font-size: 1.5rem;
            margin: 30px 0;
            padding: 15px;
            border-radius: 5px;
            text-align: center;
        }
        
        .verdict-correct {
            background-color: rgba(76, 175, 80, 0.1);
            color: var(--success);
        }
        
        .verdict-incorrect {
            background-color: rgba(255, 82, 82, 0.1);
            color: var(--error);
        }
        
        .solution-content {
            line-height: 1.8;
            font-size: 1.1rem;
        }
        
        .solution-content p {
            margin-bottom: 20px;
        }
        
        .solution-content strong {
            color: var(--accent);
        }
        
        .back-button {
            display: inline-block;
            margin-top: 30px;
            padding: 12px 25px;
            background: var(--bg-light);
            color: var(--text-light);
            text-decoration: none;
            border-radius: 5px;
            transition: var(--transition);
            border: 1px solid var(--primary);
        }
        
        .back-button:hover {
            background: var(--primary);
            transform: translateY(-2px);
        }
        
        /* Animações adicionais */
        .magnifying-glass {
            font-size: 2.5rem;
            margin-bottom: 20px;
            display: inline-block;
            animation: pulse 2s infinite;
        }
        
        .fade-in {
            animation: fadeIn 1s;
        }
        
        .slide-in {
            animation: slideInRight 0.5s;
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        .solucao-completa {
            max-height: 600px;
            overflow-y: auto;
            padding-right: 15px;
        }
        
        .solucao-completa::-webkit-scrollbar {
            width: 8px;
        }
        
        .solucao-completa::-webkit-scrollbar-track {
            background: var(--bg-darker);
            border-radius: 10px;
        }
        
        .solucao-completa::-webkit-scrollbar-thumb {
            background: var(--primary);
            border-radius: 10px;
        }
        
        /* Confetti animation only for correct answer */
        .confetti {
            position: fixed;
            width: 10px;
            height: 10px;
            background-color: var(--accent);
            top: 0;
            animation: confetti 5s ease-in-out infinite;
            z-index: -1;
        }
        
        .confetti:nth-child(2n) {
            background-color: var(--primary-light);
        }
        
        .confetti:nth-child(3n) {
            background-color: var(--success);
        }
        
        .confetti:nth-child(4n) {
            width: 5px;
            height: 5px;
        }
        
        .confetti:nth-child(5n) {
            width: 15px;
            height: 15px;
        }
        
        /* Adicionar marca d'água */
        .watermark {
            position: fixed;
            bottom: 20px;
            right: 20px;
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.3);
            z-index: 0;
            pointer-events: none;
        }
        
        /* Scrollbar personalizada */
        ::-webkit-scrollbar {
            width: 10px;
        }
        
        ::-webkit-scrollbar-track {
            background: var(--bg-darker);
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--primary);
            border-radius: 5px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--primary-light);
        }
        
        /* Melhoria de acessibilidade */
        .visually-hidden {
            position: absolute;
            width: 1px;
            height: 1px;
            margin: -1px;
            padding: 0;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            border: 0;
        }
        
        /* Loading effect para transições */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
            transition: opacity 0.5s ease-in-out;
        }
        
        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 5px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: var(--primary);
            animation: spin 1s ease-in-out infinite;
        }
        
        @keyframes confetti {
            0% {
                transform: translateY(0) rotateX(0) rotateY(0);
                opacity: 1;
            }
            100% {
                transform: translateY(100vh) rotateX(720deg) rotateY(360deg);
                opacity: 0;
            }
        }
        
        /* Keyframes */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(50px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        /* Responsividade melhorada */
        @media (max-width: 992px) {
            .container {
                padding: 30px 15px;
            }
            
            h1 {
                font-size: 2.8rem;
            }
            
            .suspects-grid {
                grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            }
        }
        
        @media (max-width: 768px) {
            h1 {
                font-size: 2.3rem;
            }
            
            .subtitle {
                font-size: 1rem;
            }
            
            .suspects-grid {
                grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
                gap: 15px;
            }
            
            .suspect-card img {
                height: 230px;
            }
            
            .result-container {
                padding: 25px 20px;
            }
            
            .result-header {
                flex-direction: column;
                text-align: center;
            }
            
            .result-img {
                margin: 0 auto 20px;
            }
            
            .verdict {
                font-size: 1.2rem;
                padding: 12px 10px;
            }
        }
        
        @media (max-width: 576px) {
            h1 {
                font-size: 1.8rem;
                margin-bottom: 10px;
            }
            
            .subtitle {
                font-size: 0.9rem;
                margin-bottom: 20px;
            }
            
            .suspects-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 12px;
            }
            
            .suspect-card img {
                height: 180px;
            }
            
            .suspect-name {
                font-size: 1rem;
            }
            
            .password-form {
                padding: 20px 15px;
                margin: 50px auto;
            }
            
            .solution-content {
                font-size: 0.95rem;
            }
            
            .confetti {
                display: none;
            }
        }
        
        @media (max-width: 380px) {
            h1 {
                font-size: 1.6rem;
            }
            
            .suspects-grid {
                grid-template-columns: 1fr;
            }
            
            .suspect-card img {
                height: 220px;
            }
        }
    </style>
</head>
<body>
    <!-- Loading overlay -->
    <div class="loading-overlay" id="loading-overlay">
        <div class="loading-spinner"></div>
    </div>
    
    <div class="container">
        <header>
            <h1 class="animate__animated animate__fadeInDown">Caso Criminal: O Assassinato de Dr. Philip Warren</h1>
            <p class="subtitle animate__animated animate__fadeIn animate__delay-1s">Descubra a verdade por trás deste misterioso crime</p>
        </header>
        
        <div class="watermark">Crime Files ©️ 2025</div>
        
        <?php if (!$authenticated): ?>
            <!-- Formulário de senha -->
            <div class="password-form">
                <div style="text-align: center;">
                    <span class="magnifying-glass">🔍</span>
                    <h2>Acesso Restrito</h2>
                </div>
                <p style="text-align: center; margin-bottom: 25px;">A senha é o seu CPF de compra que usou na Kirvano:</p>
                
                <?php if ($error): ?>
                <div class="error-message animate__animated animate__shakeX">
                    CPF inválido. Tente novamente.
                </div>
                <?php endif; ?>
                
                <form method="post" action="">
                    <div class="form-group">
                        <label for="password">CPF:</label>
                        <input type="text" id="password" name="password" required autofocus maxlength="11" pattern="[0-9]*" inputmode="numeric" placeholder="Digite os 11 dígitos sem traços ou pontos">
                        <p style="font-size: 0.8rem; margin-top: 8px; color: #aaa;">Digite os 11 dígitos do seu CPF sem traços ou pontos.</p>
                    </div>
                    <button type="submit">Verificar</button>
                </form>
            </div>
        
        <?php elseif ($selectedSuspect): ?>
            <!-- Resultado da seleção do suspeito -->
            <div class="result-container <?php echo $isCorrect ? 'result-correct' : 'result-incorrect'; ?>">
                <div class="result-header">
                    <img src="<?php echo htmlspecialchars($selectedSuspect['imagem']); ?>" alt="<?php echo htmlspecialchars($selectedSuspect['nome']); ?>" class="result-img">
                    <div>
                        <h2 class="result-title"><?php echo htmlspecialchars($selectedSuspect['nome']); ?></h2>
                        <p class="result-subtitle">Resultado da sua investigação</p>
                    </div>
                </div>
                
                <div class="verdict <?php echo $isCorrect ? 'verdict-correct' : 'verdict-incorrect'; ?>">
                    <?php if ($isCorrect): ?>
                        <span>✓</span> Você está correto! Este é o verdadeiro culpado!
                    <?php else: ?>
                        <span>✗</span> Este suspeito não é o culpado. Continue investigando!
                    <?php endif; ?>
                </div>
                
                <div class="solution-content">
                    <?php echo $selectedSuspect['solucao']; ?>
                </div>
                
                <a href="?<?php echo time(); ?>" class="back-button">Voltar aos Suspeitos</a>
            </div>
            
        <?php else: ?>
            <!-- Grid de suspeitos -->
            <div style="text-align: center;">
                <h2 class="animate__animated animate__fadeIn">Selecione o Suspeito</h2>
                <p class="animate__animated animate__fadeIn animate__delay-1s" style="max-width: 800px; margin: 0 auto 30px;">
                    Após uma extensa investigação, você chegou à sua conclusão. Clique no suspeito que acredita ser o 
                    verdadeiro assassino de Dr. Philip Warren para verificar se está correto:
                </p>
            </div>
            
            <div class="suspects-grid">
                <?php foreach ($suspects as $key => $suspect): ?>
                <a href="?suspect=<?php echo htmlspecialchars($key); ?>" class="suspect-card">
                    <img src="<?php echo htmlspecialchars($suspect['imagem']); ?>" alt="<?php echo htmlspecialchars($suspect['nome']); ?>">
                    <div class="suspect-info">
                        <h3 class="suspect-name"><?php echo htmlspecialchars($suspect['nome']); ?></h3>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Scripts gerais -->
    <script>
        // Ocultar o loading overlay quando a página carrega
        window.addEventListener('load', function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                setTimeout(() => {
                    loadingOverlay.style.display = 'none';
                }, 500);
            }
        });
        
        // Mostrar loading nas transições
        document.addEventListener('DOMContentLoaded', function() {
            const links = document.querySelectorAll('a:not([target="_blank"])');
            const forms = document.querySelectorAll('form');
            
            links.forEach(link => {
                link.addEventListener('click', function(e) {
                    if (!link.getAttribute('href').startsWith('#')) {
                        const loadingOverlay = document.getElementById('loading-overlay');
                        if (loadingOverlay) {
                            loadingOverlay.style.display = 'flex';
                            setTimeout(() => {
                                loadingOverlay.style.opacity = '1';
                            }, 10);
                        }
                    }
                });
            });
            
            forms.forEach(form => {
                form.addEventListener('submit', function() {
                    const loadingOverlay = document.getElementById('loading-overlay');
                    if (loadingOverlay) {
                        loadingOverlay.style.display = 'flex';
                        setTimeout(() => {
                            loadingOverlay.style.opacity = '1';
                        }, 10);
                    }
                });
            });
        });
        
        <?php if ($isCorrect): ?>
        // Criar confetti para resposta correta
        function createConfetti() {
            const container = document.body;
            const confettiCount = 150;
            const colors = ['#8B0000', '#FFD700', '#C41E3A', '#DAA520', '#4CAF50'];
            
            for (let i = 0; i < confettiCount; i++) {
                const confetti = document.createElement('div');
                confetti.classList.add('confetti');
                
                // Características aleatórias
                confetti.style.left = Math.random() * 100 + 'vw';
                confetti.style.animationDelay = Math.random() * 5 + 's';
                confetti.style.animationDuration = Math.random() * 3 + 3 + 's';
                confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                
                // Formas variadas
                if (Math.random() > 0.5) {
                    confetti.style.borderRadius = '50%';
                } else if (Math.random() > 0.5) {
                    confetti.style.width = '8px';
                    confetti.style.height = '8px';
                    confetti.style.transform = 'rotate(45deg)';
                }
                
                container.appendChild(confetti);
                
                // Remover após a animação
                setTimeout(() => {
                    confetti.remove();
                }, 8000);
            }
        }
        
        // Iniciar confetti com um pequeno atraso para garantir que a página esteja carregada
        setTimeout(createConfetti, 500);
        <?php endif; ?>
    </script>
</body>
</html>