<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mystery of Ravenwood – Murder Investigation Game for Couples</title>
  
  <!-- SEO Meta Tags -->
  <meta name="description" content="Turn your date into an immersive investigation. Mystery of Ravenwood - discover who murdered Emma Collins in an engaging investigative thriller for couples.">
  <meta name="keywords" content="detective game, murder investigation, mystery, game for couples, Emma Collins, Ravenwood, abandoned church">
  
  <!-- Social Sharing Meta Tags -->
  <meta property="og:title" content="Mystery of Ravenwood – Murder at the Abandoned Church">
  <meta property="og:description" content="A journalist was murdered. Seven suspects. Countless secrets. Can you unravel the mystery that haunts Ravenwood?">
  <meta property="og:image" content="images/emma_cartaz.jpeg">
  <meta property="og:url" content="https://seusite.com/mystery-ravenwood">
  <meta property="og:type" content="website">
  
  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Abril+Fatface&family=EB+Garamond:wght@400;500;600;700&family=Montserrat:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  
  <!-- Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  
  <style>
    /* Color Variables - Enhanced Noir and Mysterious Atmosphere */
    :root {
      --blood-red: #990000;
      --dark-blood: #660000;
      --bright-blood: #CC0000;
      --accent-red: #FF3333;
      --bg-black: #0A0A0A;
      --bg-darker: #070707;
      --bg-dark-gray: #151515;
      --bg-medium-gray: #1E1E1E;
      --text-white: #FFFFFF;
      --text-light: #F0F0F0;
      --text-muted: #BBBBBB;
      --accent-gold: #D4AF37;
      --border-color: #333333;
      --success-green: #4CAF50;
      --shadow-dark: rgba(0,0,0,0.5);
      --shadow-red: rgba(153,0,0,0.5);
    }
    
    /* Reset and Base */
    *, *::before, *::after { 
      margin: 0; 
      padding: 0; 
      box-sizing: border-box;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
    }
    
    html { 
      scroll-behavior: smooth; 
      font-size: 16px;
      scrollbar-width: thin;
      scrollbar-color: var(--blood-red) var(--bg-black);
    }
    
    ::-webkit-scrollbar {
      width: 8px;
    }
    
    ::-webkit-scrollbar-track {
      background: var(--bg-black);
    }
    
    ::-webkit-scrollbar-thumb {
      background-color: var(--blood-red);
      border-radius: 4px;
    }
    
    body {
      font-family: 'Montserrat', sans-serif;
      background: var(--bg-black);
      color: var(--text-light);
      line-height: 1.6;
      overflow-x: hidden;
      text-rendering: optimizeLegibility;
      position: relative;
      min-height: 100vh;
    }
    
    h1, h2, h3, h4 {
      font-family: 'Abril Fatface', serif;
      font-weight: 400;
      letter-spacing: 1px;
      line-height: 1.2;
    }
    
    h5, h6, blockquote {
      font-family: 'EB Garamond', serif;
    }
    
    a { 
      text-decoration: none; 
      color: inherit; 
      transition: all 0.3s ease;
    }
    
    img {
      max-width: 100%;
      height: auto;
    }
    
    p {
      margin-bottom: 1rem;
    }
    
    /* Text Effects */
    .text-shadow {
      text-shadow: 2px 2px 4px var(--shadow-dark);
    }
    
    .blood-text {
      color: var(--blood-red);
      text-shadow: 0 0 2px rgba(255, 0, 0, 0.3);
    }
    
    .cursive-highlight {
      font-family: 'EB Garamond', serif;
      font-style: italic;
      font-weight: 500;
    }
    
    /* Main CTA Button - Enhanced */
    .cta-button {
      display: inline-block;
      padding: 1rem 2rem;
      background: var(--blood-red);
      color: var(--text-white);
      font-weight: 700;
      text-transform: uppercase;
      letter-spacing: 1.5px;
      border-radius: 3px;
      border: none;
      cursor: pointer;
      font-size: 1.1rem;
      text-align: center;
      position: relative;
      overflow: hidden;
      transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      box-shadow: 0 5px 15px rgba(153, 0, 0, 0.4), 0 3px 5px rgba(0, 0, 0, 0.3);
      transform: translateY(0);
    }
    
    .cta-button:hover {
      background: var(--dark-blood);
      transform: translateY(-3px);
      box-shadow: 0 8px 20px rgba(153, 0, 0, 0.6), 0 4px 8px rgba(0, 0, 0, 0.4);
    }
    
    .cta-button:active {
      transform: translateY(-1px);
      box-shadow: 0 5px 15px rgba(153, 0, 0, 0.4);
    }
    
    .cta-button::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
      transition: all 0.6s ease;
    }
    
    .cta-button:hover::before {
      left: 100%;
    }
    
    /* Pulsing CTA Button - Enhanced Effect */
    .pulse {
      animation: pulseShadow 2.5s infinite;
    }
    
    @keyframes pulseShadow {
      0% { box-shadow: 0 5px 15px rgba(153, 0, 0, 0.4), 0 3px 5px rgba(0, 0, 0, 0.3); }
      50% { box-shadow: 0 5px 25px rgba(153, 0, 0, 0.7), 0 3px 10px rgba(0, 0, 0, 0.4); }
      100% { box-shadow: 0 5px 15px rgba(153, 0, 0, 0.4), 0 3px 5px rgba(0, 0, 0, 0.3); }
    }
    
    /* Secondary Outline Button */
    .outline-button {
      background: transparent;
      border: 2px solid var(--blood-red);
      color: var(--blood-red);
      box-shadow: none;
      transition: all 0.3s ease;
    }
    
    .outline-button:hover {
      background: rgba(153, 0, 0, 0.1);
      color: var(--text-light);
      box-shadow: 0 5px 15px rgba(153, 0, 0, 0.2);
    }
    
    /* Enhanced Progress Bar with Visual Effect */
    #progressBarContainer {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background: rgba(0, 0, 0, 0.9);
      z-index: 1000;
    }
    
    #progressBar {
      height: 100%;
      width: 0%;
      background: linear-gradient(90deg, 
        var(--dark-blood), 
        var(--blood-red), 
        var(--bright-blood), 
        var(--accent-red), 
        var(--blood-red), 
        var(--dark-blood));
      background-size: 200% 100%;
      animation: gradientFlow 3s ease infinite;
      box-shadow: 0 0 10px rgba(153, 0, 0, 0.7);
      transition: width 0.2s ease;
    }
    
    @keyframes gradientFlow {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }
    
    /* Start Screen with Enhanced Atmospheric Effect */
    #startScreen {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100vh;
      z-index: 2000;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      text-align: center;
      padding: 1.25rem;
      background: linear-gradient(
        rgba(10, 10, 10, 0.85),
        rgba(10, 10, 10, 0.75)
      ), url('imagens/emma_cartaz.jpeg');
      background-size: cover;
      background-position: center;
      transition: opacity 0.8s ease, visibility 0.8s ease;
      overflow: hidden;
    }
    
    #startScreen::before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: repeating-linear-gradient(
        to bottom,
        transparent,
        transparent 1px,
        rgba(0, 0, 0, 0.05) 1px,
        rgba(0, 0, 0, 0.05) 2px
      );
      pointer-events: none;
      opacity: 0.3;
      z-index: 1;
    }
    
    #startScreen h1 {
      font-size: 3.5rem;
      margin-bottom: 1.25rem;
      color: var(--text-white);
      text-shadow: 0 0 40px var(--dark-blood), 2px 2px 3px rgba(0, 0, 0, 0.6);
      position: relative;
      z-index: 2;
      line-height: 1.1;
    }
    
    #startScreen h1 span {
      color: var(--blood-red);
      display: block;
      font-size: 5rem;
      text-shadow: 0 0 20px rgba(153, 0, 0, 0.7), 2px 2px 4px black;
      letter-spacing: 2px;
      animation: pulseText 2s infinite alternate;
      line-height: 1.2;
    }
    
    @keyframes pulseText {
      from { text-shadow: 0 0 20px rgba(153, 0, 0, 0.3), 2px 2px 4px black; }
      to { text-shadow: 0 0 30px rgba(153, 0, 0, 0.7), 2px 2px 4px black; }
    }
    
    #startScreen p {
      font-size: 1.4rem;
      color: var(--text-light);
      max-width: 800px;
      margin-bottom: 2.5rem;
      position: relative;
      z-index: 2;
      font-weight: 300;
      line-height: 1.8;
    }
    
    #startScreen button {
      padding: 1.25rem 2.5rem;
      font-size: 1.3rem;
      color: var(--text-white);
      border: none;
      border-radius: 3px;
      cursor: pointer;
      font-weight: 700;
      letter-spacing: 1.5px;
      text-transform: uppercase;
      position: relative;
      z-index: 2;
      overflow: hidden;
      background: var(--blood-red);
      box-shadow: 0 5px 20px rgba(153, 0, 0, 0.7), 0 3px 6px rgba(0, 0, 0, 0.4);
      transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    }
    
    #startScreen button:hover {
      transform: scale(1.05) translateY(-3px);
      box-shadow: 0 8px 25px rgba(153, 0, 0, 0.8), 0 5px 10px rgba(0, 0, 0, 0.4);
      background: var(--bright-blood);
    }
    
    #startScreen button:active {
      transform: scale(1.02) translateY(-1px);
    }
    
    #startScreen .bloodstain {
      position: absolute;
      width: 300px;
      height: 300px;
      background-image: url('bloodstain.png');
      background-size: contain;
      background-repeat: no-repeat;
      background-position: center;
      opacity: 0.15;
      filter: blur(1px);
      z-index: 1;
      transform: rotate(var(--rotation)) scale(var(--scale));
    }
    
    #startScreen .bloodstain:nth-child(1) {
      top: 10%;
      left: 5%;
      --rotation: 45deg;
      --scale: 1.2;
    }
    
    #startScreen .bloodstain:nth-child(2) {
      bottom: 15%;
      right: 10%;
      --rotation: -30deg;
      --scale: 0.9;
    }
    
    #startScreen .bloodstain:nth-child(3) {
      top: 60%;
      left: 20%;
      --rotation: 15deg;
      --scale: 0.7;
    }
    
    /* Hero Header with Enhanced Atmospheric Animation */
    header {
      position: relative;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: center;
      padding: 0 1.25rem;
      background: linear-gradient(
        rgba(10, 10, 10, 0.80),
        rgba(10, 10, 10, 0.75)
      ), url('imagens/emma_cartaz.jpeg');
      background-size: cover;
      background-position: center;
      overflow: hidden;
    }
    
    header::before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: repeating-linear-gradient(
        to bottom,
        transparent,
        transparent 1px,
        rgba(0, 0, 0, 0.05) 1px,
        rgba(0, 0, 0, 0.05) 2px
      );
      pointer-events: none;
      opacity: 0.2;
      z-index: 1;
    }
    
    .hero-content {
      position: relative;
      z-index: 10;
      max-width: 900px;
      width: 100%;
      animation: fadeSlideUp 1.5s ease-out;
      padding: 2.5rem;
      background: rgba(10, 10, 10, 0.75);
      backdrop-filter: blur(5px);
      border-radius: 5px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
      border: 1px solid rgba(153, 0, 0, 0.2);
    }
    
    @keyframes fadeSlideUp {
      from { opacity: 0; transform: translateY(40px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    /* Animated Header Title with Typewriter Effect */
    .title-container {
      position: relative;
      height: 5rem;
      margin-bottom: 1.25rem;
      overflow: hidden;
    }
    
    #typedHeader {
      font-size: 3.2rem;
      color: var(--text-white);
      text-shadow: 0 0 30px rgba(153, 0, 0, 0.5), 2px 2px 3px black;
      position: relative;
      width: 100%;
      opacity: 0;
      transform: translateY(40px);
      box-sizing: border-box;
      padding: 0 10px;
      line-height: 1.1;
      text-align: center;
      word-break: break-word;
    }
    
    #typedHeader.animated {
      opacity: 1;
      transform: translateY(0);
      transition: opacity 0.5s ease, transform 0.5s ease;
    }
    
    .cursor {
      display: inline-block;
      width: 3px;
      height: 3.5rem;
      background-color: var(--blood-red);
      margin-left: 5px;
      position: relative;
      top: 0.8rem;
      animation: blink 1s step-end infinite;
    }
    
    @keyframes blink {
      from, to { opacity: 1; }
      50% { opacity: 0; }
    }
    
    .hero-content p {
      font-size: 1.2rem;
      margin-bottom: 1.875rem;
      color: var(--text-light);
      text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.5);
      font-weight: 300;
      line-height: 1.6;
      max-width: 800px;
      margin-left: auto;
      margin-right: auto;
    }
    
    /* Hero Buttons - Responsive Flex Container */
    .hero-buttons {
      display: flex;
      gap: 1.25rem;
      justify-content: center;
      margin-top: 2rem;
      flex-wrap: wrap;
    }
    
    /* Mini Benefits with Refined Icons */
    .mini-benefits {
      display: flex;
      justify-content: center;
      margin-top: 2rem;
      gap: 1.25rem;
      flex-wrap: wrap;
    }
    
    .mini-benefit {
      display: flex;
      align-items: center;
      background: rgba(0, 0, 0, 0.5);
      padding: 0.6rem 1rem;
      border-radius: 3px;
      backdrop-filter: blur(5px);
      border: 1px solid rgba(153, 0, 0, 0.2);
      transition: all 0.3s ease;
    }
    
    .mini-benefit:hover {
      transform: translateY(-3px);
      background: rgba(20, 20, 20, 0.7);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }
    
    .mini-benefit i {
      color: var(--blood-red);
      margin-right: 0.5rem;
      font-size: 1.1rem;
    }
    
    /* Dripping Blood Effect on the Hero - More Realistic */
    .blood-drip {
      position: absolute;
      top: 0;
      width: 2px;
      background: var(--blood-red);
      z-index: 1;
      box-shadow: 0 0 5px rgba(153, 0, 0, 0.5);
      opacity: 0.7;
      animation: drip var(--drip-time) ease-in var(--drip-delay) forwards;
    }
    
    .blood-drip::after {
      content: "";
      position: absolute;
      bottom: 0;
      left: 50%;
      transform: translateX(-50%);
      width: var(--drip-size);
      height: var(--drip-size);
      background: var(--blood-red);
      border-radius: 50%;
      box-shadow: 0 0 5px rgba(153, 0, 0, 0.5);
    }
    
    @keyframes drip {
      0% { height: 0; }
      100% { height: var(--drip-height); }
    }
    
    /* General Section Settings - Improved Spacing */
    section { 
      padding: 5rem 1.25rem; 
      text-align: center;
      position: relative;
      overflow: hidden;
    }
    
    .content-wrapper { 
      max-width: 1200px; 
      margin: 0 auto;
      position: relative;
      z-index: 10;
    }
    
    /* Section Titles with Enhanced Visual Details */
    .section-title {
      font-size: 3.5rem;
      margin-bottom: 1.5rem;
      position: relative;
      display: inline-block;
      color: var(--text-white);
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
      word-wrap: break-word;
      max-width: 100%;
    }
    
    .section-title::after {
      content: "";
      display: block;
      width: 100px;
      height: 3px;
      background: var(--blood-red);
      margin: 0.625rem auto 0;
      box-shadow: 0 0 10px rgba(153, 0, 0, 0.5);
    }
    
    .section-subtitle {
      font-family: 'EB Garamond', serif;
      font-size: 1.5rem;
      font-style: italic;
      color: var(--text-muted);
      margin-bottom: 3rem;
      max-width: 800px;
      margin-left: auto;
      margin-right: auto;
    }
    
    /* Section Container with Police Report Style - Enhanced */
    .section-container {
      background: var(--bg-dark-gray);
      border-radius: 5px;
      padding: 3rem 2.5rem;
      margin: 2.5rem auto;
      max-width: 1000px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
      border: 1px solid var(--border-color);
      position: relative;
      overflow: hidden;
    }
    
    .section-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 5px;
      height: 100%;
      background: var(--blood-red);
      box-shadow: 0 0 15px rgba(153, 0, 0, 0.7);
    }
    
    /* Smooth Fade-In Animations */
    .fade-in {
      opacity: 0;
      transform: translateY(40px);
      transition: opacity 0.8s ease-out, transform 0.8s ease-out;
    }
    
    .fade-in.visible {
      opacity: 1;
      transform: translateY(0);
    }
    
    /* Watermark Style for Sections */
    .watermark {
      position: absolute;
      font-family: 'Abril Fatface', serif;
      color: rgba(153, 0, 0, 0.04);
      font-size: 15rem;
      line-height: 1;
      z-index: 1;
      pointer-events: none;
      user-select: none;
      white-space: nowrap;
    }
    
    .watermark-top-right {
      top: -3rem;
      right: -3rem;
      transform: rotate(10deg);
    }
    
    .watermark-bottom-left {
      bottom: -3rem;
      left: -3rem;
      transform: rotate(-10deg);
    }
    
    /* Section: The Case - Enhanced Contrast and Legibility */
    #detalhes {
      background: var(--bg-dark-gray);
      position: relative;
    }
    
    #detalhes::after {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: url('texture.png');
      opacity: 0.02;
      z-index: 1;
      pointer-events: none;
    }
    
    #detalhes .section-container {
      text-align: left;
      background: var(--bg-medium-gray);
      border: 1px solid rgba(153, 0, 0, 0.2);
    }
    
    #detalhes .case-content {
      position: relative;
      z-index: 10;
      font-size: 1.1rem;
      line-height: 1.7;
    }
    
    #detalhes .case-content p { 
      margin-bottom: 1rem;
    }
    
    #detalhes .case-content strong {
      color: var(--blood-red);
      font-weight: 700;
      text-shadow: 0 0 1px rgba(153, 0, 0, 0.3);
    }
    
    /* News Bulletin with TV News Effect - Enhanced Visuals */
    .news-bulletin {
      border: 1px solid var(--blood-red);
      padding: 1.5rem;
      margin: 2rem 0;
      background: rgba(153, 0, 0, 0.05);
      border-radius: 5px;
      position: relative;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
    
    .news-bulletin::before {
      content: 'URGENT NEWS';
      position: absolute;
      top: -0.75rem;
      left: 1.5rem;
      background: var(--bg-medium-gray);
      padding: 0 0.625rem;
      font-size: 0.8rem;
      color: var(--blood-red);
      font-weight: bold;
      letter-spacing: 1px;
    }
    
    .breaking-news {
      display: inline-block;
      overflow: hidden;
      border-right: 2px solid var(--blood-red);
      white-space: nowrap;
      margin: 0 auto;
      letter-spacing: 2px;
      font-family: 'EB Garamond', serif;
      font-weight: 600;
      font-size: 1.8rem;
      color: var(--blood-red);
      text-shadow: 0 0 1px rgba(153, 0, 0, 0.3);
      animation: typing 3.5s steps(40, end), blink-caret 0.75s step-end infinite;
    }
    
    @keyframes typing {
      from { width: 0 }
      to { width: 100% }
    }
    
    @keyframes blink-caret {
      from, to { border-color: transparent }
      50% { border-color: var(--blood-red); }
    }
    
    /* Section: Suspects with Polaroid Cards - Enhanced 3D Effect */
    #suspeitos {
      background: var(--bg-black);
      position: relative;
    }
    
    .suspects-container {
      display: flex;
      justify-content: center;
      gap: 2rem;
      flex-wrap: wrap;
      margin-top: 3rem;
    }
    
    .suspect-card {
      flex: 0 1 300px;
      background: var(--bg-medium-gray);
      border-radius: 5px;
      overflow: hidden;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
      transition: all 0.4s ease;
      transform-style: preserve-3d;
      perspective: 1000px;
      transform: rotateY(0deg);
      position: relative;
    }
    
    .suspect-card:hover {
      transform: translateY(-10px) rotateY(0deg);
      box-shadow: 0 15px 40px rgba(0, 0, 0, 0.7), 0 5px 15px rgba(153, 0, 0, 0.3);
    }
    
    .suspect-card:hover .suspect-photo img {
      transform: scale(1.05);
    }
    
    .suspect-card .card-front {
      padding: 0;
      position: relative;
      transform: rotateY(0deg);
      backface-visibility: hidden;
      transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .suspect-card .card-back {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      padding: 1.5rem;
      background: var(--bg-medium-gray);
      transform: rotateY(180deg);
      backface-visibility: hidden;
      transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
    }
    
    .suspect-card.flipped .card-front {
      transform: rotateY(180deg);
    }
    
    .suspect-card.flipped .card-back {
      transform: rotateY(0deg);
    }
    
    .suspect-photo {
      height: 250px;
      overflow: hidden;
      position: relative;
    }
    
    .suspect-photo img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.5s ease;
    }
    
    .suspect-photo::after {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(to bottom, 
        rgba(0, 0, 0, 0) 50%, 
        rgba(0, 0, 0, 0.8) 100%);
    }
    
    .suspect-info {
      padding: 1.5rem;
      position: relative;
      text-align: left;
    }
    
    .suspect-name {
      color: var(--text-white);
      font-size: 1.5rem;
      margin-bottom: 0.3rem;
      position: relative;
    }
    
    .suspect-role {
      font-family: 'EB Garamond', serif;
      font-style: italic;
      color: var(--text-muted);
      font-size: 1rem;
      margin-bottom: 1rem;
    }
    
    .suspect-motive {
      color: var(--text-muted);
      font-size: 0.95rem;
      line-height: 1.6;
      word-wrap: break-word;
      overflow-wrap: break-word;
    }
    
    .flip-card-btn {
      position: absolute;
      bottom: 1rem;
      right: 1rem;
      width: 30px;
      height: 30px;
      background: var(--blood-red);
      color: var(--text-white);
      border: none;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: all 0.3s ease;
      opacity: 0.8;
      font-size: 0.8rem;
    }
    
    .flip-card-btn:hover {
      opacity: 1;
      transform: rotate(180deg);
    }
    
    .evidence-tag {
      position: absolute;
      top: 1rem;
      left: 0;
      background: var(--blood-red);
      color: var(--text-white);
      padding: 0.3rem 0.8rem;
      font-size: 0.8rem;
      font-weight: 700;
      box-shadow: 0 3px 8px rgba(0, 0, 0, 0.3);
      z-index: 10;
    }
    
    /* Investigation Materials Section - Improved Layout */
    #materiais {
      background: var(--bg-dark-gray);
      position: relative;
      padding: 5rem 1.25rem;
    }
    
    .features-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
      gap: 2.5rem;
      margin-top: 3rem;
    }
    
    .feature-card {
      background: var(--bg-medium-gray);
      border-radius: 5px;
      overflow: hidden;
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.4);
      border: 1px solid var(--border-color);
      transition: all 0.4s ease;
      height: 100%;
      display: flex;
      flex-direction: column;
    }
    
    .feature-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.6), 0 5px 15px rgba(153, 0, 0, 0.2);
    }
    
    .feature-img {
      height: 230px;
      overflow: hidden;
      position: relative;
      background-color: #333;
    }
    
    .feature-img img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.6s ease;
    }
    
    .feature-card:hover .feature-img img {
      transform: scale(1.08);
    }
    
    .feature-content {
      padding: 1.875rem;
      text-align: left;
      display: flex;
      flex-direction: column;
      flex-grow: 1;
    }
    
    .feature-title {
      color: var(--blood-red);
      font-size: 1.5rem;
      margin-bottom: 1rem;
      position: relative;
    }
    
    .feature-title::after {
      content: "";
      position: absolute;
      bottom: -0.5rem;
      left: 0;
      width: 50px;
      height: 2px;
      background: var(--blood-red);
      box-shadow: 0 0 5px rgba(153, 0, 0, 0.3);
    }
    
    .feature-desc {
      color: var(--text-muted);
      font-size: 1rem;
      line-height: 1.6;
      margin-bottom: 1.5rem;
    }
    
    .feature-extra {
      margin-top: auto;
      padding-top: 1rem;
      font-style: italic;
      color: var(--text-light);
      font-size: 0.95rem;
      border-top: 1px dashed rgba(153, 0, 0, 0.2);
    }
    
    /* Section: How It Works - Enhanced Visual Highlights */
    #como-funciona {
      background: url('suspeitos/emma.jpeg') center center/cover;
      position: relative;
    }
    
    #como-funciona::before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: var(--bg-black);
      opacity: 0.85;
      z-index: 1;
    }
    
    #como-funciona .content-wrapper {
      position: relative;
      z-index: 10;
    }
    
    #como-funciona .section-container {
      text-align: left;
    }
    
    #como-funciona p { 
      font-size: 1.1rem; 
      margin-bottom: 1.5rem;
      color: var(--text-light);
    }
    
    #como-funciona p strong {
      color: var(--blood-red);
      font-weight: 700;
      text-shadow: 0 0 1px rgba(153, 0, 0, 0.3);
    }
    
    .checklist {
      list-style: none;
      margin: 2rem auto;
      padding: 0;
      max-width: 800px;
      text-align: left;
    }
    
    .checklist li { 
      margin-bottom: 1rem; 
      padding-left: 2rem;
      position: relative;
      color: var(--text-muted);
      font-size: 1.1rem;
    }
    
    .checklist li::before {
      content: '\f058';
      font-family: 'Font Awesome 5 Free';
      font-weight: 900;
      color: var(--blood-red);
      position: absolute;
      left: 0;
      top: 0.2rem;
      font-size: 1.2rem;
    }
    
    /* Section: Testimonials - Completely Redesigned */
    #depoimentos {
      background: var(--bg-black);
      position: relative;
      padding: 6rem 1.25rem;
    }
    
    .testimonials-container { 
      position: relative; 
      margin: 3rem auto;
      max-width: 900px;
    }
    
    .testimonial-carousel {
      position: relative;
      perspective: 1200px;
      height: 400px;
      margin-bottom: 3rem;
    }
    
    .testimonial-card {
      position: absolute;
      width: 70%;
      max-width: 600px;
      height: 100%;
      left: 15%;
      top: 0;
      background: var(--bg-medium-gray);
      border-radius: 8px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
      transition: transform 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275),
                  opacity 0.8s ease,
                  box-shadow 0.8s ease;
      padding: 2.5rem;
      opacity: 0;
      transform: translateX(100%) rotateY(-60deg) scale(0.8);
      pointer-events: none;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
      border: 1px solid rgba(153, 0, 0, 0.2);
    }
    
    .testimonial-card.active {
      opacity: 1;
      transform: translateX(0) rotateY(0) scale(1);
      z-index: 10;
      pointer-events: auto;
      box-shadow: 0 25px 50px rgba(0, 0, 0, 0.7), 0 10px 20px rgba(153, 0, 0, 0.2);
      border: 1px solid rgba(153, 0, 0, 0.3);
    }
    
    .testimonial-card.prev {
      opacity: 0.7;
      transform: translateX(-70%) rotateY(60deg) scale(0.8);
      z-index: 5;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.4);
    }
    
    .testimonial-card.next {
      opacity: 0.7;
      transform: translateX(70%) rotateY(-60deg) scale(0.8);
      z-index: 5;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.4);
    }
    
    .testimonial-avatar {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      object-fit: cover;
      border: 3px solid var(--blood-red);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
      margin-bottom: 1.5rem;
    }
    
    .testimonial-quote {
      font-family: 'EB Garamond', serif;
      font-style: italic;
      font-size: 1.3rem;
      color: var(--text-light);
      margin-bottom: 1.5rem;
      line-height: 1.8;
      position: relative;
      word-wrap: break-word;
      overflow-wrap: break-word;
      width: 100%;
      max-width: 100%;
      box-sizing: border-box;
    }
    
    .testimonial-quote::before,
    .testimonial-quote::after {
      content: '"';
      font-family: 'Abril Fatface', serif;
      font-size: 4rem;
      color: var(--blood-red);
      position: absolute;
      opacity: 0.2;
      line-height: 0;
    }
    
    .testimonial-quote::before {
      top: 0.5rem;
      left: -1.5rem;
    }
    
    .testimonial-quote::after {
      bottom: -1rem;
      right: -1.5rem;
      transform: rotate(180deg);
    }
    
    .testimonial-rating {
      color: var(--accent-gold);
      font-size: 1.2rem;
      margin-bottom: 0.8rem;
      letter-spacing: 0.2rem;
    }
    
    .testimonial-author {
      font-weight: 600;
      color: var(--blood-red);
      font-size: 1.1rem;
    }
    
    .testimonial-nav {
      display: flex;
      justify-content: center;
      gap: 1rem;
      margin-top: 2rem;
    }
    
    .testimonial-btn {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      border: none;
      background: var(--blood-red);
      color: var(--text-white);
      font-size: 1.1rem;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }
    
    .testimonial-btn:hover {
      background: var(--bright-blood);
      transform: translateY(-3px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.4);
    }
    
    .testimonial-btn:active {
      transform: translateY(-1px);
    }
    
    .dots-container {
      display: flex;
      justify-content: center;
      gap: 0.5rem;
      margin: 2rem 0;
    }
    
    .dot {
      width: 12px;
      height: 12px;
      background: var(--bg-medium-gray);
      border-radius: 50%;
      cursor: pointer;
      transition: all 0.3s ease;
      border: 1px solid rgba(153, 0, 0, 0.3);
    }
    
    .dot.active {
      background: var(--blood-red);
      transform: scale(1.2);
      box-shadow: 0 0 8px rgba(153, 0, 0, 0.5);
    }
    
    /* Section: Purchase with Urgency Effect - Enhanced Visually */
    #comprar {
      background: linear-gradient(to bottom, var(--bg-black), var(--bg-dark-gray));
      position: relative;
      padding-bottom: 7rem;
    }
    
    .purchase-container {
      display: flex;
      align-items: center;
      justify-content: space-between;
      gap: 3rem;
      margin-top: 3rem;
      flex-wrap: wrap;
    }
    
    .product-preview {
      flex: 1 1 350px;
      position: relative;
      perspective: 1000px;
    }
    
    .product-image {
      width: 100%;
      border-radius: 5px;
      box-shadow: 0 15px 40px rgba(0, 0, 0, 0.7);
      transition: all 0.5s ease;
      transform: rotateY(0deg);
      transform-style: preserve-3d;
    }
    
    .product-preview:hover .product-image {
      transform: rotateY(5deg);
      box-shadow: 20px 20px 40px rgba(0, 0, 0, 0.8);
    }
    
    .product-badge {
      position: absolute;
      top: -15px;
      right: -15px;
      background: var(--blood-red);
      color: var(--text-white);
      font-size: 0.9rem;
      font-weight: 700;
      padding: 0.5rem 1rem;
      border-radius: 3px;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
      z-index: 5;
      transform: rotate(5deg);
    }
    
    .product-badge i {
      margin-right: 0.3rem;
    }
    
    .product-info {
      flex: 1 1 400px;
      text-align: left;
    }
    
    .product-title {
      font-size: 2.8rem;
      color: var(--text-white);
      line-height: 1.1;
      margin-bottom: 0.5rem;
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
      word-wrap: break-word;
      overflow-wrap: break-word;
      width: 100%;
    }
    
    .product-subtitle {
      font-family: 'EB Garamond', serif;
      font-size: 1.6rem;
      font-style: italic;
      color: var(--text-muted);
      margin-bottom: 1.5rem;
      word-wrap: break-word;
      overflow-wrap: break-word;
      width: 100%;
    }
    
    .product-description {
      font-size: 1.1rem;
      margin-bottom: 1.5rem;
      line-height: 1.7;
      color: var(--text-light);
    }
    
    .product-features {
      list-style: none;
      margin: 1.5rem 0;
      padding: 0;
    }
    
    .product-features li {
      display: flex;
      align-items: flex-start;
      margin-bottom: 1rem;
      color: var(--text-muted);
      font-size: 1.05rem;
    }
    
    .product-features i {
      color: var(--blood-red);
      margin-right: 0.8rem;
      margin-top: 0.3rem;
      font-size: 1rem;
    }
    
    /* PRICE SECTION - Updated to Euros */
    .price-container {
      margin: 2rem 0;
      display: flex;
      align-items: center;
      flex-wrap: wrap;
      gap: 1rem;
    }
    
    /* Set original price to €39,90 and current price to €20,00 */
    .original-price {
      font-size: 1.4rem;
      text-decoration: line-through;
      color: var(--text-muted);
    }
    
    .current-price {
      font-size: 2.5rem;
      font-weight: 700;
      color: var(--blood-red);
      text-shadow: 0 0 1px rgba(153, 0, 0, 0.3);
    }
    
    /* Guarantee Badge */
    .guarantee-badge {
      display: inline-flex;
      align-items: center;
      background: rgba(76, 175, 80, 0.1);
      padding: 0.8rem 1.2rem;
      border-radius: 3px;
      margin: 1.5rem 0;
      border: 1px solid rgba(76, 175, 80, 0.3);
    }
    
    .guarantee-badge i {
      color: var(--success-green);
      margin-right: 0.8rem;
      font-size: 1.1rem;
    }
    
    .guarantee-badge span {
      color: var(--text-light);
      font-size: 1rem;
    }
    
    .stock-indicator {
      font-size: 0.9rem;
      color: var(--text-muted);
      margin-top: 1.5rem;
      display: flex;
      align-items: center;
      flex-wrap: wrap;
      gap: 0.5rem;
    }
    
    .stock-bar {
      width: 150px;
      height: 6px;
      background: rgba(255, 255, 255, 0.1);
      border-radius: 3px;
      overflow: hidden;
    }
    
    .stock-level {
      height: 100%;
      width: 30%;
      background: var(--blood-red);
      border-radius: 3px;
    }
    
    .payment-options {
      margin-top: 2rem;
      text-align: center;
    }
    
    .payment-label {
      display: block;
      color: var(--text-muted);
      font-size: 0.9rem;
      margin-bottom: 0.8rem;
    }
    
    .payment-methods {
      display: flex;
      gap: 0.8rem;
      flex-wrap: wrap;
      justify-content: center;
    }
    
    .payment-method {
      background: rgba(255, 255, 255, 0.05);
      padding: 0.5rem 1rem;
      border-radius: 3px;
      display: flex;
      align-items: center;
    }
    
    .payment-method i {
      color: var(--text-white);
      font-size: 1.2rem;
    }
    
    /* "Back to Top" Button - Enhanced Visuals */
    #scrollToTopBtn {
      position: fixed;
      bottom: 2rem;
      right: 2rem;
      width: 50px;
      height: 50px;
      border-radius: 50%;
      background: var(--blood-red);
      color: var(--text-white);
      border: none;
      font-size: 1.25rem;
      cursor: pointer;
      opacity: 0;
      transform: scale(0.8);
      transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      z-index: 100;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }
    
    #scrollToTopBtn.visible {
      opacity: 1;
      transform: scale(1);
    }
    
    #scrollToTopBtn:hover {
      background: var(--bright-blood);
      transform: scale(1.1) translateY(-5px);
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.4);
    }
    
    /* Purchase Confirmation Modal - Redesigned */
    .modal {
      display: none;
      position: fixed;
      z-index: 2000;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      overflow: auto;
      background: rgba(0, 0, 0, 0.85);
      backdrop-filter: blur(5px);
      transition: all 0.5s ease;
    }
    
    .modal-content {
      background: var(--bg-dark-gray);
      margin: 10% auto;
      width: 90%;
      max-width: 500px;
      border-radius: 8px;
      box-shadow: 0 25px 50px rgba(0, 0, 0, 0.5);
      border: 1px solid rgba(153, 0, 0, 0.2);
      position: relative;
      animation: modalDrop 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      overflow: hidden;
    }
    
    @keyframes modalDrop {
      from { opacity: 0; transform: translateY(-50px); }
      to { opacity: 1; transform: translateY(0); }
    }
    
    .modal-header {
      padding: 1.5rem;
      text-align: center;
      position: relative;
      border-bottom: 1px solid rgba(153, 0, 0, 0.2);
    }
    
    .modal-title {
      color: var(--blood-red);
      font-size: 2rem;
      margin-bottom: 0.5rem;
    }
    
    .modal-body {
      padding: 2rem 1.5rem;
      text-align: center;
    }
    
    .modal-body p {
      font-size: 1.1rem;
      margin-bottom: 1rem;
      color: var(--text-muted);
    }
    
    .modal-footer {
      padding: 1.5rem;
      text-align: center;
      border-top: 1px solid rgba(153, 0, 0, 0.1);
    }
    
    .close-modal {
      position: absolute;
      top: 1rem;
      right: 1rem;
      color: var(--text-muted);
      font-size: 1.5rem;
      font-weight: 700;
      cursor: pointer;
      transition: all 0.3s ease;
      width: 30px;
      height: 30px;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 50%;
    }
    
    .close-modal:hover {
      color: var(--text-white);
      transform: rotate(90deg);
      background: rgba(153, 0, 0, 0.1);
    }
    
    /* Atmospheric Footer - Enhanced Visual Appearance */
    footer {
      background: var(--bg-darker);
      color: var(--text-muted);
      padding: 3rem 1.25rem;
      text-align: center;
      position: relative;
      overflow: hidden;
    }
    
    footer::before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background: linear-gradient(90deg, 
        var(--dark-blood), 
        var(--blood-red), 
        var(--bright-blood), 
        var(--blood-red), 
        var(--dark-blood));
      background-size: 200% 100%;
      animation: gradientFlow 3s ease infinite;
    }
    
    .footer-content {
      max-width: 1200px;
      margin: 0 auto;
      position: relative;
      z-index: 10;
    }
    
    .social-links {
      margin-bottom: 2rem;
    }
    
    .social-link {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 40px;
      height: 40px;
      background: var(--bg-dark-gray);
      color: var(--text-light);
      border-radius: 50%;
      margin: 0 0.5rem;
      transition: all 0.3s ease;
      box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
    }
    
    .social-link:hover {
      background: var(--blood-red);
      transform: translateY(-5px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }
    
    .footer-links {
      margin-bottom: 2rem;
    }
    
    .footer-link {
      margin: 0 1rem;
      color: var(--text-muted);
      font-size: 0.95rem;
      transition: all 0.3s ease;
    }
    
    .footer-link:hover {
      color: var(--blood-red);
    }
    
    .copyright {
      padding-top: 1.5rem;
      border-top: 1px solid rgba(255, 255, 255, 0.05);
      font-size: 0.9rem;
    }
    
    /* Optimized Media Queries */
    @media (max-width: 1200px) {
      .section-title { font-size: 3rem; }
      .product-title { font-size: 2.5rem; }
      .product-subtitle { font-size: 1.4rem; }
      
      .hero-content p {
        font-size: 1.3rem;
      }
    }
    
    @media (max-width: 992px) {
      html { font-size: 15px; }
      
      .testimonial-card {
        width: 80%;
        left: 10%;
      }
      
      .breaking-news {
        font-size: 1.6rem;
        white-space: normal;
      }
      
      .feature-desc {
        font-size: 0.95rem;
      }
    }
    
    @media (max-width: 768px) {
      html { font-size: 14px; }
      
      #startScreen h1 { font-size: 2.8rem; }
      #startScreen h1 span { font-size: 3.5rem; }
      
      .title-container { height: 3.5rem; }
      #typedHeader { font-size: 2.5rem; }
      
      .hero-content {
        width: 90%;
        padding: 2rem 1.5rem;
      }
      
      .hero-content p {
        font-size: 1.1rem;
        line-height: 1.6;
      }
      
      .hero-buttons {
        flex-direction: column;
        gap: 1rem;
        width: 100%;
        max-width: 350px;
        margin-left: auto;
        margin-right: auto;
      }
      
      section {
        padding: 4rem 1rem;
      }
      
      .section-container {
        padding: 2rem 1.5rem;
      }
      
      .purchase-container {
        flex-direction: column;
        align-items: center;
        text-align: center;
      }
      
      .product-info {
        text-align: center;
      }
      
      .product-features li {
        justify-content: center;
      }
      
      .testimonial-card {
        width: 90%;
        left: 5%;
        padding: 2rem 1.5rem;
        height: auto;
        min-height: 350px;
      }
      
      .testimonial-card.prev,
      .testimonial-card.next {
        opacity: 0;
        pointer-events: none;
      }
      
      .testimonial-quote {
        font-size: 1.2rem;
      }
      
      .testimonial-quote::before {
        left: -1rem;
      }
      
      .testimonial-quote::after {
        right: -1rem;
      }
      
      .suspect-card {
        margin-bottom: 1rem;
      }
      
      .suspect-motive {
        font-size: 0.9rem;
      }
      
      .section-subtitle {
        padding: 0 1rem;
      }
      
      /* Better readability on smaller screens */
      .case-content p {
        font-size: 1rem;
        line-height: 1.6;
      }
      
      .checklist li {
        font-size: 0.95rem;
        line-height: 1.5;
        margin-bottom: 1.2rem;
      }
      
      /* Hide blood drips on smaller screens */
      .blood-drip {
        display: none;
      }
      
      /* Better adjustments for mini-benefits */
      .mini-benefits {
        margin-top: 1.5rem;
        flex-direction: column;
        align-items: center;
        gap: 0.8rem;
      }
      
      .mini-benefit {
        width: 100%;
        max-width: 280px;
        justify-content: center;
      }
    }
    
    @media (max-width: 576px) {
      html { font-size: 13px; }
      
      section {
        padding: 3rem 0.8rem;
      }
      
      #startScreen h1 { 
        font-size: 2.2rem; 
        line-height: 1;
        margin-bottom: 1rem;
      }
      #startScreen h1 span { 
        font-size: 2.8rem; 
        line-height: 1.1;
      }
      #startScreen p { 
        font-size: 1.1rem;
        padding: 0 1rem; 
        line-height: 1.5;
      }
      #startScreen button {
        padding: 1rem 2rem;
        font-size: 1.1rem;
        width: 90%;
        max-width: 280px;
      }
      
      .title-container { height: 3rem; }
      #typedHeader { 
        font-size: 2rem; 
        white-space: normal;
        position: relative;
        margin: 0 auto;
        top: auto;
        left: auto;
      }
      
      .cursor {
        height: 2.5rem;
        top: 0.5rem;
      }
      
      .section-title { 
        font-size: 2rem; 
        padding: 0 0.5rem;
        line-height: 1.1;
      }
      .section-subtitle { 
        font-size: 1.1rem;
        padding: 0 1rem;
      }
      
      .hero-content {
        padding: 1.5rem 1rem;
        width: 95%;
      }
      
      .hero-content p {
        font-size: 1rem;
        margin-bottom: 1.5rem;
        line-height: 1.5;
      }
      
      .cta-button {
        width: 100%;
        padding: 0.9rem 1.5rem;
        font-size: 1rem;
      }
      
      .product-title { font-size: 1.8rem; }
      .product-subtitle { font-size: 1.2rem; }
      .product-description { font-size: 1rem; }
      
      .footer-link {
        display: block;
        margin: 1rem 0;
      }
      
      /* Better adjustments for mobile */
      .watermark {
        font-size: 8rem;
      }
      
      .breaking-news {
        font-size: 1.3rem;
        white-space: normal;
        line-height: 1.4;
      }
      
      .news-bulletin {
        padding: 1.2rem 1rem;
      }
      
      .testimonial-carousel {
        height: 380px;
      }
      
      .testimonial-avatar {
        width: 80px;
        height: 80px;
      }
      
      .suspect-card {
        max-width: 100%;
      }
      
      .suspect-photo {
        height: 200px;
      }
      
      .product-image {
        max-width: 90%;
        margin: 0 auto;
      }
      
      .product-features li {
        align-items: flex-start;
      }
      
      .product-features i {
        margin-top: 0.2rem;
      }
      
      .current-price {
        font-size: 2.2rem;
      }
      
      .original-price {
        font-size: 1.3rem;
      }
      
      .limited-offer span {
        font-size: 1rem;
        padding: 0.2rem 0.4rem;
      }
      
      .bloodstain {
        width: 200px;
        height: 200px;
      }
    }
    
    /* Extra small devices */
    @media (max-width: 400px) {
      html { font-size: 12px; }
      
      #startScreen h1 { font-size: 1.8rem; }
      #startScreen h1 span { font-size: 2.4rem; }
      #startScreen p { 
        font-size: 1rem;
        margin-bottom: 1.5rem;
      }
      
      .title-container { height: 2.8rem; }
      #typedHeader { font-size: 1.8rem; }
      
      .hero-content {
        padding: 1.2rem 1rem;
        width: 92%;
      }
      
      .hero-content p {
        font-size: 0.95rem;
        margin-bottom: 1.2rem;
      }
      
      .section-title { font-size: 2rem; }
      
      .suspect-name { font-size: 1.3rem; }
      .suspect-role { font-size: 0.9rem; }
      
      .testimonial-carousel {
        height: 430px;
      }
      
      .testimonial-quote {
        font-size: 1rem;
      }
      
      .case-content p {
        font-size: 0.95rem;
      }
      
      .feature-title {
        font-size: 1.3rem;
      }
      
      .testimonial-btn {
        width: 40px;
        height: 40px;
      }
      
      .bloodstain {
        width: 150px;
        height: 150px;
      }
    }
  </style>
</head>
<body>
  <!-- Progress Bar -->
  <div id="progressBarContainer"><div id="progressBar"></div></div>
  
  <!-- Start Screen -->
  <div id="startScreen">
    <div class="bloodstain"></div>
    <div class="bloodstain"></div>
    <div class="bloodstain"></div>
    
    <h1>Discover the Mystery of<br><span>Ravenwood</span></h1>
    <p>A murdered journalist. Seven suspects. Countless secrets. An immersive experience for you and your partner to solve together.</p>
    <button onclick="document.getElementById('startScreen').style.display='none';">Start Investigation</button>
  </div>
  
  <!-- Header -->
  <header>
    <!-- Dripping Blood Effect -->
    <div class="blood-drip" style="left: 10%; --drip-height: 45%; --drip-time: 5s; --drip-delay: 1s; --drip-size: 8px;"></div>
    <div class="blood-drip" style="left: 25%; --drip-height: 35%; --drip-time: 4s; --drip-delay: 2s; --drip-size: 6px;"></div>
    <div class="blood-drip" style="left: 75%; --drip-height: 40%; --drip-time: 4.5s; --drip-delay: 0.5s; --drip-size: 7px;"></div>
    <div class="blood-drip" style="left: 90%; --drip-height: 30%; --drip-time: 3.5s; --drip-delay: 1.5s; --drip-size: 5px;"></div>
    
    <div class="hero-content">
      <div class="title-container">
        <h1 id="typedHeader">Mystery of Ravenwood</h1>
        <div class="cursor"></div>
      </div>
      
      <p>A shocking murder at the abandoned church. Occult symbols. Dark secrets. Dive into this terrifying investigation and discover who silenced journalist Emma Collins forever.</p>
      
      <div class="hero-buttons">
        <a href="#detalhes" class="cta-button pulse crime-btn">Investigate the Crime</a>
        <a href="#comprar" class="cta-button outline-button offer-btn">See Special Offer</a>
      </div>
      
      <!-- Mini Benefits -->
      <div class="mini-benefits">
        <div class="mini-benefit">
          <i class="fas fa-bolt"></i>
          <span>Instant digital delivery</span>
        </div>
        <div class="mini-benefit">
          <i class="fas fa-print"></i>
          <span>Ready to play</span>
        </div>
        <div class="mini-benefit">
          <i class="fas fa-star"></i>
          <span>2-3 hours of immersion</span>
        </div>
      </div>
    </div>
  </header>
  
  <!-- "Back to Top" Button -->
  <button id="scrollToTopBtn" onclick="scrollToTop()"><i class="fas fa-arrow-up"></i></button>
  
  <!-- Section: The Case -->
  <section id="detalhes">
    <div class="watermark watermark-top-right">CRIME</div>
    
    <div class="content-wrapper">
      <h2 class="section-title">The Crime</h2>
      <p class="section-subtitle">A murder that shook the quiet town of Ravenwood</p>
      
      <div class="section-container fade-in">
        <div class="case-content">
          <div class="news-bulletin">
            <p class="breaking-news">MURDER IN RAVENWOOD</p>
          </div>
          
          <p><strong>A shocking crime has rocked the quiet town of Ravenwood.</strong> The body of Emma Collins, an investigative journalist known for exposing local secrets, was found at the abandoned church on the outskirts of town.</p>
          
          <p>According to police sources, the victim’s body was discovered on the altar in a <strong>disturbing scene with occult symbols</strong> drawn around it. Investigators suspect the crime may be linked to a series of tips provided by Emma about prominent figures in the community.</p>
          
          <p>The reporter was on the verge of revealing a dark secret that could forever change the fate of this small town. Each suspect has their own motive, and every clue tells a different story.</p>
          
          <p><strong>Who silenced this journalist forever? It’s up to you to find out.</strong></p>
        </div>
        
        <div style="text-align: center; margin-top: 2rem;">
          <a href="#comprar" class="cta-button">I Want to Investigate This Case</a>
        </div>
      </div>
    </div>
  </section>
  
  <!-- Section: Suspects -->
  <section id="suspeitos">
    <div class="watermark watermark-bottom-left">SUSPECTS</div>
    
    <div class="content-wrapper">
      <h2 class="section-title">The Suspects</h2>
      <p class="section-subtitle">Seven suspects, each with their own motives, secrets, and lies</p>
      
      <div class="suspects-container">
        <!-- Suspect 1 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #1</div>
            <div class="suspect-photo">
              <img src="suspeitos/richard.jpeg" alt="Mayor Richard Grant">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">Richard Howard Grant</h3>
              <div class="suspect-role">City Mayor</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              A threatening email was sent to Emma two days before the murder. Mere intimidation or something more sinister?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
        
        <!-- Suspect 2 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #2</div>
            <div class="suspect-photo">
              <img src="suspeitos/michael.jpeg" alt="Reverend Michael Shaw">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">Michael Thomas Shaw</h3>
              <div class="suspect-role">Local Reverend</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              An ancient book on religious rituals with marked pages was found in his office. Coincidence or a crucial clue?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
        
        <!-- Suspect 3 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #3</div>
            <div class="suspect-photo">
              <img src="suspeitos/james.jpeg" alt="Dr. James Wilson">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">James Robert Wilson</h3>
              <div class="suspect-role">Respected Doctor</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              Falsified medical records were discovered on Emma's computer. What medical secret is he hiding?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
        
        <!-- Suspect 4 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #4</div>
            <div class="suspect-photo">
              <img src="suspeitos/helen.jpeg" alt="Helen Brooks">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">Helen Margaret Brooks</h3>
              <div class="suspect-role">President of the Historical Society</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              A drawing identical to the symbols found at the crime scene was discovered in her home. Old art or a meticulously planned scheme?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
        
        <!-- Suspect 5 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #5</div>
            <div class="suspect-photo">
              <img src="suspeitos/daniel.jpeg" alt="Daniel Collins">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">Daniel Joseph Collins</h3>
              <div class="suspect-role">Victim’s Brother</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              A newly contracted insurance policy in Emma's name with Daniel as beneficiary. Financial planning or premeditation?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
        
        <!-- Suspect 6 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #6</div>
            <div class="suspect-photo">
              <img src="suspeitos/sarah.jpeg" alt="Sarah Mitchell">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">Sarah Elizabeth Mitchell</h3>
              <div class="suspect-role">Best Friend of the Victim</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              Deleted messages reveal a recent fight between the two friends. What secret was hidden in those conversations?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
        
        <!-- Suspect 7 -->
        <div class="suspect-card fade-in">
          <div class="card-front">
            <div class="evidence-tag">SUSPECT #7</div>
            <div class="suspect-photo">
              <img src="suspeitos/thomas.jpeg" alt="Sheriff Thomas Reed">
            </div>
            <div class="suspect-info">
              <h3 class="suspect-name">Thomas William Reed</h3>
              <div class="suspect-role">Ravenwood Sheriff</div>
              <button class="flip-card-btn" onclick="flipCard(this)">
                <i class="fas fa-sync-alt"></i>
              </button>
            </div>
          </div>
          <div class="card-back">
            <h3 class="suspect-name">Evidence Found</h3>
            <p class="suspect-motive">
              A tampered police report was found in the sheriff's office. What crime is he trying to cover up?
            </p>
            <button class="flip-card-btn" onclick="flipCard(this)">
              <i class="fas fa-sync-alt"></i>
            </button>
          </div>
        </div>
      </div>
      
      <div style="text-align: center; margin-top: 3rem;">
        <a href="#comprar" class="cta-button">I Want to Uncover These Secrets</a>
      </div>
    </div>
  </section>
  
  <!-- Section: Investigation Materials -->
  <section id="materiais">
    <div class="watermark watermark-top-right">EVIDENCE</div>
    
    <div class="content-wrapper">
      <h2 class="section-title">Investigation Materials</h2>
      <p class="section-subtitle">Exclusive documents to help you analyze the case</p>
      
      <div class="features-grid">
        <!-- Material 1 -->
        <div class="feature-card fade-in">
          <div class="feature-img">
            <img src="imagens/relatorios.png" alt="Police Reports">
          </div>
          <div class="feature-content">
            <h3 class="feature-title">Police Reports</h3>
            <p class="feature-desc">Detailed crime scene reports, forensic analyses, and the initial official investigations.</p>
            <div class="feature-extra">
              <p>Includes photographs of the crime scene and confidential details never revealed to the press.</p>
            </div>
          </div>
        </div>
        
        <!-- Material 2 -->
        <div class="feature-card fade-in">
          <div class="feature-img">
            <img src="imagens/depoimentos.png" alt="Suspects' Testimonies">
          </div>
          <div class="feature-content">
            <h3 class="feature-title">Testimonies</h3>
            <p class="feature-desc">Complete transcripts of interrogations with each of the seven suspects.</p>
            <div class="feature-extra">
              <p>Analyze contradictions, detect lies, and uncover secrets revealed only between the lines.</p>
            </div>
          </div>
        </div>
        
        <!-- Material 3 -->
        <div class="feature-card fade-in">
          <div class="feature-img">
            <img src="imagens/evidencias.png" alt="Crucial Evidence">
          </div>
          <div class="feature-content">
            <h3 class="feature-title">Crucial Evidence</h3>
            <p class="feature-desc">Physical proof, cryptic messages, and decisive clues gathered during the investigation.</p>
            <div class="feature-extra">
              <p>Meticulously compiled elements that will guide you to the true culprit.</p>
            </div>
          </div>
        </div>
      </div>
      
      <div style="text-align: center; margin-top: 3rem;">
        <a href="#comprar" class="cta-button">Secure My Access to the Dossier</a>
      </div>
    </div>
  </section>
  
  <!-- Section: How It Works -->
  <section id="como-funciona">
    <div class="content-wrapper">
      <h2 class="section-title">How It Works</h2>
      <p class="section-subtitle">An immersive and engaging experience for couples</p>
      
      <div class="section-container fade-in">
        <p><strong>A complete investigative experience:</strong> After purchase, you will instantly receive a complete digital file containing everything you need to solve the mystery of Ravenwood.</p>
        
        <ul class="checklist">
          <li>The complete dossier with all the case details</li>
          <li>Detailed profiles of the 7 suspects with backgrounds and possible motives</li>
          <li>Photographs of the crime scene and forensic evidence</li>
          <li>Transcripts of testimonies and witness interviews</li>
          <li>Exclusive documents revealing the secrets of Ravenwood</li>
          <li>A step-by-step guide to conduct your investigation</li>
          <li>A link for access to additional clues and the complete solution</li>
        </ul>
        
        <p>Work together, analyze every clue, connect the evidence, and uncover the true murderer in this mystery that lasts on average <strong>2 to 3 hours of pure immersion</strong>.</p>
        
        <div style="text-align: center; margin-top: 2rem;">
          <a href="#comprar" class="cta-button">I Want to Unravel This Mystery</a>
        </div>
      </div>
    </div>
  </section>
  
  <!-- Section: Testimonials - Completely Redesigned -->
  <section id="depoimentos">
    <div class="watermark watermark-bottom-left">TESTIMONIALS</div>
    
    <div class="content-wrapper">
      <h2 class="section-title">What Investigators Are Saying</h2>
      <p class="section-subtitle">Real experiences from couples who have solved this mystery</p>
      
      <div class="testimonials-container fade-in">
        <div class="testimonial-carousel">
          <!-- Testimonial 1 -->
          <div class="testimonial-card">
            <img src="avatares/julia.jpg" alt="Avatar of Julia" class="testimonial-avatar">
            <p class="testimonial-quote">Our night was incredible! We felt like real detectives unraveling Ravenwood's secrets. The clues are challenging and the ending is surprising!</p>
            <div class="testimonial-rating">★★★★★</div>
            <p class="testimonial-author">– Julia and Pedro, 12/03/2025</p>
          </div>
          
          <!-- Testimonial 2 -->
          <div class="testimonial-card next">
            <img src="avatares/samuel.jpg" alt="Avatar of Samuel" class="testimonial-avatar">
            <p class="testimonial-quote">The quality of the material is impressive! Every document seems authentic and the theories we created that night brought us closer than ever.</p>
            <div class="testimonial-rating">★★★★★</div>
            <p class="testimonial-author">– Samuel and Amanda, 05/03/2025</p>
          </div>
          
          <!-- Testimonial 3 -->
          <div class="testimonial-card">
            <img src="avatares/andre.jpg" alt="Avatar of André" class="testimonial-avatar">
            <p class="testimonial-quote">We've played many investigation games, but this one truly exceeded our expectations. The story is engrossing and the clues are very well designed!</p>
            <div class="testimonial-rating">★★★★★</div>
            <p class="testimonial-author">– André and Camila, 28/02/2025</p>
          </div>
          
          <!-- Testimonial 4 -->
          <div class="testimonial-card">
            <img src="avatares/ilana.jpg" alt="Avatar of Ilana" class="testimonial-avatar">
            <p class="testimonial-quote">Perfect for a different kind of night! My boyfriend loved the investigation and we spent hours discussing theories about who could be the murderer.</p>
            <div class="testimonial-rating">★★★★★</div>
            <p class="testimonial-author">– Ilana and Bruno, 20/02/2025</p>
          </div>
          
          <!-- Testimonial 5 -->
          <div class="testimonial-card prev">
            <img src="avatares/sofia.jpg" alt="Avatar of Sofia" class="testimonial-avatar">
            <p class="testimonial-quote">We bought it for our wedding anniversary and it was the best decision! Completely immersive, it felt like we were part of a detective series.</p>
            <div class="testimonial-rating">★★★★★</div>
            <p class="testimonial-author">– Sofia and Roberto, 15/02/2025</p>
          </div>
        </div>
        
        <div class="testimonial-nav">
          <button class="testimonial-btn" onclick="prevTestimonial()">
            <i class="fas fa-chevron-left"></i>
          </button>
          <button class="testimonial-btn" onclick="nextTestimonial()">
            <i class="fas fa-chevron-right"></i>
          </button>
        </div>
        
        <div class="dots-container">
          <span class="dot active" onclick="goToTestimonial(0)"></span>
          <span class="dot" onclick="goToTestimonial(1)"></span>
          <span class="dot" onclick="goToTestimonial(2)"></span>
          <span class="dot" onclick="goToTestimonial(3)"></span>
          <span class="dot" onclick="goToTestimonial(4)"></span>
        </div>
      </div>
      
      <div style="text-align: center; margin-top: 2rem;">
        <a href="#comprar" class="cta-button">I Want This Experience</a>
      </div>
    </div>
  </section>
  
  <!-- Section: Purchase -->
  <section id="comprar">
    <div class="watermark watermark-top-right">MYSTERY</div>
    
    <div class="content-wrapper">
      <h2 class="section-title">Solve the Mystery</h2>
      <p class="section-subtitle">Turn your date into a fascinating and unforgettable investigation</p>
      
      <div class="purchase-container fade-in">
        <div class="product-preview">
            <div class="product-image">
              <img src="imagens/emma_cartaz.jpeg" alt="Mystery of Ravenwood – Murder at the Abandoned Church">
              <div class="product-badge">
                <i class="fas fa-fire"></i> LAUNCH
              </div>
            </div>
        </div>
        
        <div class="product-info">
          <h2 class="product-title">Mystery of Ravenwood</h2>
          <h3 class="product-subtitle">Murder at the Abandoned Church</h3>
          
          <div class="limited-offer">
            <i class="fas fa-clock"></i> Launch offer: <span id="hours">01</span>:<span id="minutes">45</span>:<span id="seconds">22</span>
          </div>
          
          <p class="product-description">
            Turn your date into a fascinating murder investigation! Analyze clues, interrogate suspects, and uncover Ravenwood's dark secrets together.
          </p>
          
          <ul class="product-features">
            <li>
              <i class="fas fa-check-circle"></i>
              <span>Complete dossier with over 40 pages of content</span>
            </li>
            <li>
              <i class="fas fa-check-circle"></i>
              <span>Instant digital delivery</span>
            </li>
            <li>
              <i class="fas fa-check-circle"></i>
              <span>Perfect for mystery-loving couples</span>
            </li>
          </ul>
          
          <div class="price-container">
            <span class="original-price">€39,90</span>
            <span class="current-price">€20,00</span>
          </div>
          
          <div class="guarantee-badge">
            <i class="fas fa-shield-alt"></i>
            <span>7-day satisfaction guarantee</span>
          </div>
          
          <button class="cta-button pulse" id="buy-button">Start My Investigation!</button>
          
          <div class="stock-indicator">
            <span>Only 12 copies left at this price</span>
            <div class="stock-bar"><div class="stock-level"></div></div>
          </div>
          

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  
  <!-- Purchase Confirmation Modal -->
  <div id="purchaseModal" class="modal">
    <div class="modal-content">
      <div class="modal-header">
        <h2 class="modal-title">Purchase Confirmed!</h2>
        <span class="close-modal">&times;</span>
      </div>
      <div class="modal-body">
        <p>Thank you for purchasing Mystery of Ravenwood!</p>
        <p>You will receive the download link in your email shortly.</p>
        <p>Get ready for an unforgettable investigative experience!</p>
      </div>
      <div class="modal-footer">
        <a href="#" class="cta-button">Access Client Area</a>
      </div>
    </div>
  </div>
  
  <!-- Footer -->
  <footer>
    <div class="footer-content">
      <div class="social-links">
        <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
        <a href="#" class="social-link"><i class="fab fa-facebook-f"></i></a>
        <a href="#" class="social-link"><i class="fab fa-whatsapp"></i></a>
      </div>
      <div class="footer-links">
        <a href="#" class="footer-link">About Us</a>
        <a href="#" class="footer-link">Other Games</a>
        <a href="#" class="footer-link">Privacy Policy</a>
        <a href="#" class="footer-link">Contact</a>
      </div>
      <div class="copyright">
        <p>&copy; 2025 Duo Games. All rights reserved.</p>
      </div>
    </div>
  </footer>
  
  <!-- Enhanced Scripts -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.3.2/html2canvas.min.js"></script>
  <script>
    // Update progress bar as the user scrolls
    document.addEventListener("scroll", function() {
      var winScroll = document.body.scrollTop || document.documentElement.scrollTop;
      var height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
      var scrolled = (winScroll / height) * 100;
      var progressBar = document.getElementById("progressBar");
      if (progressBar) {
        progressBar.style.width = scrolled + "%";
      }
      
      // "Back to Top" Button
      var btn = document.getElementById("scrollToTopBtn");
      if (btn) {
        if (window.pageYOffset > 300) { 
          btn.classList.add("visible"); 
        } else { 
          btn.classList.remove("visible"); 
        }
      }
    });
    
    // Scroll to top function
    function scrollToTop() { 
      window.scrollTo({ top: 0, behavior: 'smooth' }); 
    }
    
    // Flip suspect cards
    function flipCard(button) {
      var card = button.closest('.suspect-card');
      if (card) {
        card.classList.toggle('flipped');
      }
    }
    
    // Global variables for testimonial carousel
    var currentTestimonial = 0;
    var testimonials;
    var totalTestimonials;
    var dots;
    var testimonialInterval;
    
    // Run when DOM is loaded
    document.addEventListener("DOMContentLoaded", function() {
      // Typewriter effect in header
      setTimeout(function() {
        var typedHeader = document.getElementById("typedHeader");
        if (typedHeader) {
          typedHeader.classList.add('animated');
        }
      }, 500);
      
      // Fade-in for elements with class "fade-in"
      var elements = document.querySelectorAll('.fade-in');
      var observer = new IntersectionObserver(function(entries) {
        entries.forEach(function(entry) {
          if (entry.isIntersecting) {
            entry.target.classList.add('visible');
            observer.unobserve(entry.target);
          }
        });
      }, { threshold: 0.15, rootMargin: '0px 0px -50px 0px' });
      
      elements.forEach(function(el) {
        observer.observe(el);
      });
      
      // Initialize testimonial carousel
      initializeCarousel();
      
      // Start timer for countdown
      setInterval(updateTimer, 1000);
      
      // Create blood drip effects
      createBloodDrips();
      
      // Setup purchase button actions
      setupPurchaseButtons();
    });
    
    // Initialize testimonial carousel
    function initializeCarousel() {
      testimonials = document.querySelectorAll('.testimonial-card');
      if (testimonials.length === 0) {
        console.log("No testimonials found");
        return;
      }
      
      totalTestimonials = testimonials.length;
      dots = document.querySelectorAll('.dot');
      
      // Set the first slide as active
      updateTestimonialClasses();
      
      // Auto-rotate carousel
      testimonialInterval = setInterval(nextTestimonial, 5000);
      
      // Pause auto-rotation on hover
      var carousel = document.querySelector('.testimonial-carousel');
      if (carousel) {
        carousel.addEventListener('mouseenter', function() {
          clearInterval(testimonialInterval);
        });
        
        carousel.addEventListener('mouseleave', function() {
          testimonialInterval = setInterval(nextTestimonial, 5000);
        });
      }
    }
    
    function updateTestimonialClasses() {
      testimonials.forEach(function(card, index) {
        card.classList.remove('active', 'prev', 'next');
        if (index === currentTestimonial) {
          card.classList.add('active');
        } else if (index === getPrevIndex()) {
          card.classList.add('prev');
        } else if (index === getNextIndex()) {
          card.classList.add('next');
        }
      });
      
      if (dots) {
        dots.forEach(function(dot, index) {
          dot.classList.toggle('active', index === currentTestimonial);
        });
      }
    }
    
    function getPrevIndex() {
      return (currentTestimonial - 1 + totalTestimonials) % totalTestimonials;
    }
    
    function getNextIndex() {
      return (currentTestimonial + 1) % totalTestimonials;
    }
    
    function prevTestimonial() {
      currentTestimonial = getPrevIndex();
      updateTestimonialClasses();
    }
    
    function nextTestimonial() {
      currentTestimonial = getNextIndex();
      updateTestimonialClasses();
    }
    
    function goToTestimonial(index) {
      if (index >= 0 && index < totalTestimonials) {
        currentTestimonial = index;
        updateTestimonialClasses();
      }
    }
    
    // Countdown timer function
    function updateTimer() {
      var hoursElement = document.getElementById('hours');
      var minutesElement = document.getElementById('minutes');
      var secondsElement = document.getElementById('seconds');
      
      if (!hoursElement || !minutesElement || !secondsElement) return;
      
      var hours = parseInt(hoursElement.textContent);
      var minutes = parseInt(minutesElement.textContent);
      var seconds = parseInt(secondsElement.textContent);
      
      // Decrement seconds
      seconds--;
      
      // Adjust minutes and hours as needed
      if (seconds < 0) {
        seconds = 59;
        minutes--;
        
        if (minutes < 0) {
          minutes = 59;
          hours--;
          
          if (hours < 0) {
            // Reset timer for demonstration purposes
            hours = 1;
            minutes = 45;
            seconds = 22;
          }
        }
      }
      
      // Update DOM elements
      hoursElement.textContent = hours.toString().padStart(2, '0');
      minutesElement.textContent = minutes.toString().padStart(2, '0');
      secondsElement.textContent = seconds.toString().padStart(2, '0');
    }
    
    // Setup purchase button actions
    function setupPurchaseButtons() {
      var modal = document.getElementById("purchaseModal");
      var buyBtn = document.getElementById("buy-button");
      var ctaButtons = document.querySelectorAll(".cta-button:not(.crime-btn):not(.offer-btn):not(.modal .cta-button)");
      var crimeBtn = document.querySelector(".crime-btn");
      var offerBtn = document.querySelector(".offer-btn");
      var closeModalBtn = document.querySelector(".close-modal");
      
      // Configure "Investigate the Crime" button to scroll to the case section
      if (crimeBtn) {
        crimeBtn.addEventListener('click', function(e) { 
          e.preventDefault();
          var detalhesSection = document.getElementById("detalhes");
          if (detalhesSection) {
            detalhesSection.scrollIntoView({ behavior: 'smooth' }); 
          }
        });
      }
      
      // Configure "See Special Offer" button to scroll to the offer section
      if (offerBtn) {
        offerBtn.addEventListener('click', function(e) { 
          e.preventDefault();
          var comprarSection = document.getElementById("comprar");
          if (comprarSection) {
            comprarSection.scrollIntoView({ behavior: 'smooth' }); 
          }
        });
      }
      
      // Redirect other CTA buttons to the purchase section
      ctaButtons.forEach(function(btn) { 
        btn.addEventListener('click', function(e) { 
          e.preventDefault();
          var comprarSection = document.getElementById("comprar");
          if (comprarSection) {
            comprarSection.scrollIntoView({ behavior: 'smooth' }); 
          }
        });
      });
      
      // Action for the main purchase button
      if (buyBtn) {
        buyBtn.addEventListener('click', function(e) {
          window.location.href = 'https://thunder-outlet.mycartpanda.com/checkout/182861580:1';
        });
      }
      
      // Close modal when clicking the X
      if (closeModalBtn) {
        closeModalBtn.addEventListener('click', function() { 
          if (modal) {
            modal.style.display = "none";
            document.body.style.overflow = "";
          }
        });
      }
      
      // Close modal by clicking outside of it
      window.addEventListener('click', function(event) { 
        if (modal && event.target === modal) { 
          modal.style.display = "none";
          document.body.style.overflow = "";
        } 
      });
    }
    
    // Dynamic Blood Drips Effect
    function createBloodDrips() {
      var header = document.querySelector('header');
      if (!header) return;
      
      // Remove existing drips to avoid duplication
      var existingDrips = document.querySelectorAll('.blood-drip');
      existingDrips.forEach(function(drip) {
        drip.remove();
      });
      
      // Create between 4 and 7 random blood drips
      var numberOfDrips = Math.floor(Math.random() * 4) + 4;
      
      for (var i = 0; i < numberOfDrips; i++) {
        var drip = document.createElement('div');
        drip.className = 'blood-drip';
        
        // Random horizontal position
        var leftPosition = Math.random() * 100;
        drip.style.left = leftPosition + '%';
        
        // Random height
        var height = 25 + Math.random() * 30;
        drip.style.setProperty('--drip-height', height + '%');
        
        // Random drip duration
        var dripTime = 3 + Math.random() * 3;
        drip.style.setProperty('--drip-time', dripTime + 's');
        
        // Random delay
        var delay = Math.random() * 2;
        drip.style.setProperty('--drip-delay', delay + 's');
        
        // Random drip size
        var dripSize = 4 + Math.random() * 5;
        drip.style.setProperty('--drip-size', dripSize + 'px');
        
        header.appendChild(drip);
      }
    }
  </script>
</body>
</html>
