<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Extrato Bancário - First National Bank of Ravenwood</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&family=Roboto+Condensed:wght@400;700&display=swap');
        
        :root {
            --primary-color: #8B0000;
            --secondary-color: #5C0000;
            --accent-color: #fff0f0;
            --text-color: #2c2c2c;
            --light-gray: #f5f5f5;
            --warning-color: #e74c3c;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: #e0e0e0;
            color: var(--text-color);
            padding: 20px;
            display: flex;
            justify-content: center;
        }
        
        .page-container {
            width: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        
        .a4-page {
            width: 21cm;
            height: 29.7cm;
            background-color: white;
            padding: 0.8cm;
            margin-bottom: 1cm;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            position: relative;
            overflow: hidden;
            font-size: 8px;
        }
        
        .download-btn {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: background-color 0.3s;
        }
        
        .download-btn:hover {
            background-color: var(--secondary-color);
        }
        
        .download-icon {
            display: inline-block;
            width: 16px;
            height: 16px;
        }
        
        /* Cabeçalho do extrato */
        .statement-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
            border-bottom: 2px solid var(--primary-color);
            padding-bottom: 10px;
        }
        
        .bank-logo {
            width: 150px;
            height: 60px;
            background-color: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            border-radius: 4px;
        }
        
        .bank-title {
            font-size: 18px;
            font-weight: bold;
            color: var(--primary-color);
            text-align: center;
            flex-grow: 1;
            margin: 0 20px;
        }
        
        .bank-title .subtitle {
            font-size: 14px;
            font-weight: 500;
            margin-top: 5px;
            color: var(--secondary-color);
        }
        
        .confidential-banner {
            text-align: center;
            background-color: var(--primary-color);
            color: white;
            padding: 5px;
            margin: 10px 0;
            font-weight: bold;
            font-size: 12px;
            border-radius: 2px;
        }
        
        .account-info {
            display: flex;
            flex-wrap: wrap;
            background-color: var(--accent-color);
            padding: 8px;
            border-radius: 4px;
            margin-bottom: 12px;
            border: 1px solid #d0d0d0;
        }
        
        .account-info-item {
            flex: 1 1 20%;
            min-width: 160px;
            margin-bottom: 8px;
            padding-right: 10px;
        }
        
        .account-info-item strong {
            font-weight: 500;
            font-size: 11px;
            color: var(--primary-color);
        }
        
        .account-info-item span {
            display: block;
            font-size: 12px;
            margin-top: 3px;
        }
        
        /* Resumo da conta */
        .account-summary {
            margin-bottom: 12px;
            border: 1px solid #d0d0d0;
            border-radius: 4px;
            overflow: hidden;
        }
        
        .section-title {
            background-color: var(--primary-color);
            color: white;
            padding: 6px 10px;
            font-weight: 500;
            font-size: 10px;
            letter-spacing: 0.5px;
        }
        
        .summary-content {
            display: flex;
            flex-wrap: wrap;
            padding: 12px;
            background-color: #f9f9f9;
        }
        
        .summary-item {
            flex: 1 1 25%;
            min-width: 150px;
            padding: 5px;
        }
        
        .summary-item strong {
            font-size: 11px;
            display: block;
            margin-bottom: 3px;
        }
        
        .summary-item span {
            font-size: 14px;
            font-weight: 500;
            color: var(--text-color);
        }
        
        .summary-item span.positive {
            color: #27ae60;
        }
        
        .summary-item span.negative {
            color: #e74c3c;
        }
        
        /* Tabela de transações */
        .transactions-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 12px;
            font-size: 7px;
            border: 1px solid #d0d0d0;
        }
        
        .transactions-table th {
            background-color: var(--primary-color);
            color: white;
            text-align: left;
            padding: 4px 5px;
            font-weight: 500;
            font-size: 8px;
        }
        
        .transactions-table td {
            padding: 3px 5px;
            border-bottom: 1px solid #eaeaea;
        }
        
        .transactions-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .transactions-table .date {
            width: 80px;
        }
        
        .transactions-table .code {
            width: 60px;
            text-align: center;
        }
        
        .transactions-table .description {
            width: auto;
        }
        
        .transactions-table .amount {
            width: 120px;
            text-align: right;
            font-family: 'Roboto Condensed', monospace;
        }
        
        .transactions-table .balance {
            width: 120px;
            text-align: right;
            font-family: 'Roboto Condensed', monospace;
            font-weight: 500;
        }
        
        .credit {
            color: #27ae60;
        }
        
        .debit {
            color: #e74c3c;
        }
        
        /* Alertas */
        .alerts-section {
            margin-bottom: 10px;
            border: 1px solid #d0d0d0;
            border-radius: 4px;
            overflow: hidden;
        }
        
        .alerts-content {
            padding: 8px;
            background-color: #fff8e1;
            border-left: 4px solid #ffc107;
        }
        
        .alerts-title {
            font-weight: bold;
            margin-bottom: 10px;
            color: #b7761b;
        }
        
        .alerts-list {
            list-style-type: disc;
            padding-left: 20px;
            margin-bottom: 10px;
        }
        
        .alerts-list li {
            margin-bottom: 5px;
        }
        
        /* Análise de fluxo financeiro */
        .financial-analysis {
            margin-bottom: 12px;
        }
        
        .analysis-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
        }
        
        .analysis-table th {
            background-color: var(--secondary-color);
            color: white;
            text-align: left;
            padding: 7px 10px;
            font-weight: 500;
        }
        
        .analysis-table td {
            padding: 5px 8px;
            border: 1px solid #eaeaea;
        }
        
        .analysis-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        /* Rodapé */
        .footer {
            margin-top: 8px;
            text-align: center;
            font-size: 7px;
            color: #666;
            border-top: 1px solid #d0d0d0;
            padding-top: 5px;
        }
        
        .footer-logo {
            margin-bottom: 10px;
            font-weight: bold;
            color: var(--primary-color);
        }
        
        .authentication {
            background-color: #fff0f0;
            padding: 5px;
            margin-top: 5px;
            border-radius: 4px;
            font-size: 7px;
            text-align: center;
            border: 1px dashed #ccc;
        }
        
        .confidential-warning {
            font-size: 8px;
            font-style: italic;
            text-align: center;
            margin-top: 10px;
            margin-bottom: 10px;
            padding: 5px;
            border: 1px solid #d0d0d0;
            background-color: #fff0f0;
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 120px;
            color: rgba(139, 0, 0, 0.03);
            font-weight: bold;
            pointer-events: none;
            white-space: nowrap;
            z-index: 0;
        }
        
        /* Gráfico simplesmente representado como uma barra */
        .bar-chart {
            margin: 6px 0;
            width: 100%;
        }
        
        .bar-container {
            width: 100%;
            background-color: #f0f0f0;
            border-radius: 3px;
            overflow: hidden;
            height: 16px;
            display: flex;
        }
        
        .bar-segment {
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 9px;
            font-weight: 500;
        }
        
        .casino {
            background-color: #c0392b;
        }
        
        .housing {
            background-color: #a55555;
        }
        
        .food {
            background-color: #d35400;
        }
        
        .utilities {
            background-color: #8B0000;
        }
        
        .other {
            background-color: #7f8c8d;
        }
        
        .chart-legend {
            display: flex;
            flex-wrap: wrap;
            margin-top: 5px;
            font-size: 7px;
        }
        
        .legend-item {
            display: flex;
            align-items: center;
            margin-right: 15px;
            margin-bottom: 5px;
        }
        
        .color-box {
            width: 12px;
            height: 12px;
            margin-right: 5px;
            border-radius: 2px;
        }
        
        @media print {
            body {
                padding: 0;
                background-color: white;
            }
            
            .a4-page {
                box-shadow: none;
                margin: 0;
            }
            
            .download-btn {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="page-container">
        <button class="download-btn" onclick="downloadPDF()">
            <svg class="download-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                <polyline points="7 10 12 15 17 10"></polyline>
                <line x1="12" y1="15" x2="12" y2="3"></line>
            </svg>
            Baixar como PDF
        </button>

        <div class="a4-page">
            <div class="watermark">CONFIDENCIAL</div>
            
            <div class="statement-header">
                <div class="bank-logo" style="background-color: var(--primary-color);">FIRST NATIONAL BANK</div>
                <div class="bank-title">
                    FIRST NATIONAL BANK OF RAVENWOOD
                    <div class="subtitle">EXTRATO BANCÁRIO</div>
                </div>
                <div style="width: 150px;"></div>
            </div>
            
            <div class="confidential-banner">
                DOCUMENTO COM RESTRIÇÃO DE ACESSO - LEI 13.709
            </div>
            
            <div class="account-info">
                <div class="account-info-item">
                    <strong>AGÊNCIA</strong>
                    <span>0047</span>
                </div>
                <div class="account-info-item">
                    <strong>CONTA CORRENTE</strong>
                    <span>45987321-5</span>
                </div>
                <div class="account-info-item">
                    <strong>TITULAR</strong>
                    <span>DANIEL ROBERT COLLINS</span>
                </div>
                <div class="account-info-item">
                    <strong>DATA DE EMISSÃO</strong>
                    <span>10/03/2024</span>
                </div>
            </div>
            
            <div class="account-summary">
                <div class="section-title">RESUMO DA CONTA</div>
                <div class="summary-content">
                    <div class="summary-item">
                        <strong>Saldo anterior (01/01/2024)</strong>
                        <span>$3,245.78</span>
                    </div>
                    <div class="summary-item">
                        <strong>Total de depósitos</strong>
                        <span class="positive">+$75,000.00</span>
                    </div>
                    <div class="summary-item">
                        <strong>Total de retiradas/pagamentos</strong>
                        <span class="negative">-$48,885.97</span>
                    </div>
                    <div class="summary-item">
                        <strong>Saldo atual (09/03/2024)</strong>
                        <span>$29,359.81</span>
                    </div>
                </div>
            </div>
            
            <div class="transactions">
                <div class="section-title">MOVIMENTAÇÕES DETALHADAS</div>
                <table class="transactions-table">
                    <thead>
                        <tr>
                            <th class="date">Data</th>
                            <th class="code">Código</th>
                            <th class="description">Histórico</th>
                            <th class="amount">Valor ($)</th>
                            <th class="balance">Saldo ($)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>01/01/2024</td>
                            <td>-</td>
                            <td>SALDO ANTERIOR</td>
                            <td class="amount"></td>
                            <td class="balance">3,245.78</td>
                        </tr>
                        <tr>
                            <td>08/01/2024</td>
                            <td>701</td>
                            <td>DEP TRANSF ENTRE CONTAS - HERITAGE SOLUTIONS (REF: VENDA PROP. FAMILIAR)</td>
                            <td class="amount credit">+45,000.00</td>
                            <td class="balance">48,245.78</td>
                        </tr>
                        <tr>
                            <td>10/01/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - SUPERMERCADO VALE VERDE</td>
                            <td class="amount debit">-173.45</td>
                            <td class="balance">48,072.33</td>
                        </tr>
                        <tr>
                            <td>12/01/2024</td>
                            <td>018</td>
                            <td>SAQUE 24H 47892364</td>
                            <td class="amount debit">-5,000.00</td>
                            <td class="balance">43,072.33</td>
                        </tr>
                        <tr>
                            <td>15/01/2024</td>
                            <td>105</td>
                            <td>DÉB AUTOPAG - RAVENWOOD ENERGY CO.</td>
                            <td class="amount debit">-127.35</td>
                            <td class="balance">42,944.98</td>
                        </tr>
                        <tr>
                            <td>17/01/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - SUPERMERCADO VALE VERDE</td>
                            <td class="amount debit">-235.67</td>
                            <td class="balance">42,709.31</td>
                        </tr>
                        <tr>
                            <td>19/01/2024</td>
                            <td>110</td>
                            <td>DÉB AUTOPAG - RAVENWOOD TELECOM</td>
                            <td class="amount debit">-94.50</td>
                            <td class="balance">42,614.81</td>
                        </tr>
                        <tr>
                            <td>22/01/2024</td>
                            <td>303</td>
                            <td>TRANSF PIX - LUCKY STAR CASINO</td>
                            <td class="amount debit">-3,500.00</td>
                            <td class="balance">39,114.81</td>
                        </tr>
                        <tr>
                            <td>25/01/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - FARMÁCIA CENTRAL</td>
                            <td class="amount debit">-67.85</td>
                            <td class="balance">39,046.96</td>
                        </tr>
                        <tr>
                            <td>28/01/2024</td>
                            <td>105</td>
                            <td>DÉB AUTOPAG - BIRCH APARTMENTS</td>
                            <td class="amount debit">-1,200.00</td>
                            <td class="balance">37,846.96</td>
                        </tr>
                        <tr>
                            <td>29/01/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - POSTO EAGLE</td>
                            <td class="amount debit">-64.20</td>
                            <td class="balance">37,782.76</td>
                        </tr>
                        <tr>
                            <td>31/01/2024</td>
                            <td>407</td>
                            <td>TAR MENSAL PACOTE SERVIÇOS</td>
                            <td class="amount debit">-35.90</td>
                            <td class="balance">37,746.86</td>
                        </tr>
                        <tr>
                            <td>01/02/2024</td>
                            <td>400</td>
                            <td>JUROS S/ SALDO MÉDIO CREDOR</td>
                            <td class="amount credit">+435.90</td>
                            <td class="balance">38,182.76</td>
                        </tr>
                        <tr>
                            <td>02/02/2024</td>
                            <td>018</td>
                            <td>SAQUE 24H 49872135</td>
                            <td class="amount debit">-5,000.00</td>
                            <td class="balance">33,182.76</td>
                        </tr>
                        <tr>
                            <td>05/02/2024</td>
                            <td>110</td>
                            <td>DÉB AUTOPAG - RAVENWOOD TELECOM</td>
                            <td class="amount debit">-89.50</td>
                            <td class="balance">33,093.26</td>
                        </tr>
                        <tr>
                            <td>07/02/2024</td>
                            <td>701</td>
                            <td>DEP TRANSF ENTRE CONTAS - HERITAGE SOLUTIONS (REF: VENDA PROP. FAMILIAR)</td>
                            <td class="amount credit">+30,000.00</td>
                            <td class="balance">63,093.26</td>
                        </tr>
                        <tr>
                            <td>10/02/2024</td>
                            <td>321</td>
                            <td>TRANSF ONLINE - LUCKY STAR CASINO</td>
                            <td class="amount debit">-7,500.00</td>
                            <td class="balance">55,593.26</td>
                        </tr>
                        <tr>
                            <td>15/02/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - SUPERMERCADO VALE VERDE</td>
                            <td class="amount debit">-187.45</td>
                            <td class="balance">55,405.81</td>
                        </tr>
                        <tr>
                            <td>17/02/2024</td>
                            <td>105</td>
                            <td>DÉB AUTOPAG - RAVENWOOD ENERGY CO.</td>
                            <td class="amount debit">-132.50</td>
                            <td class="balance">55,273.31</td>
                        </tr>
                        <tr>
                            <td>18/02/2024</td>
                            <td>320</td>
                            <td>DÉB CARTÃO - THE RUSTY NAIL BAR</td>
                            <td class="amount debit">-148.75</td>
                            <td class="balance">55,124.56</td>
                        </tr>
                        <tr>
                            <td>19/02/2024</td>
                            <td>018</td>
                            <td>SAQUE 24H 50123789</td>
                            <td class="amount debit">-4,500.00</td>
                            <td class="balance">50,624.56</td>
                        </tr>
                        <tr>
                            <td>24/02/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - LOJA ESPORTIVA HAWK</td>
                            <td class="amount debit">-218.75</td>
                            <td class="balance">50,405.81</td>
                        </tr>
                        <tr>
                            <td>25/02/2024</td>
                            <td>321</td>
                            <td>TRANSF ONLINE - LUCKY STAR CASINO</td>
                            <td class="amount debit">-10,000.00</td>
                            <td class="balance">40,405.81</td>
                        </tr>
                        <tr>
                            <td>27/02/2024</td>
                            <td>105</td>
                            <td>DÉB AUTOPAG - BIRCH APARTMENTS</td>
                            <td class="amount debit">-1,200.00</td>
                            <td class="balance">39,205.81</td>
                        </tr>
                        <tr>
                            <td>28/02/2024</td>
                            <td>407</td>
                            <td>TAR MENSAL PACOTE SERVIÇOS</td>
                            <td class="amount debit">-35.90</td>
                            <td class="balance">39,169.91</td>
                        </tr>
                        <tr>
                            <td>29/02/2024</td>
                            <td>400</td>
                            <td>JUROS S/ SALDO MÉDIO CREDOR</td>
                            <td class="amount credit">+535.90</td>
                            <td class="balance">39,705.81</td>
                        </tr>
                        <tr>
                            <td>01/03/2024</td>
                            <td>018</td>
                            <td>SAQUE 24H 51876423 - CAIXA CENTRAL</td>
                            <td class="amount debit">-2,000.00</td>
                            <td class="balance">37,705.81</td>
                        </tr>
                        <tr>
                            <td>03/03/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - OFICINA MECÂNICA FORD</td>
                            <td class="amount debit">-780.45</td>
                            <td class="balance">36,925.36</td>
                        </tr>
                        <tr>
                            <td>05/03/2024</td>
                            <td>321</td>
                            <td>TRANSF ONLINE - LUCKY STAR CASINO</td>
                            <td class="amount debit">-8,000.00</td>
                            <td class="balance">28,925.36</td>
                        </tr>
                        <tr>
                            <td>06/03/2024</td>
                            <td>105</td>
                            <td>DÉB AUTOPAG - RAVENWOOD ENERGY CO.</td>
                            <td class="amount debit">-135.67</td>
                            <td class="balance">28,789.69</td>
                        </tr>
                        <tr>
                            <td>07/03/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - FARMÁCIA CENTRAL</td>
                            <td class="amount debit">-92.55</td>
                            <td class="balance">28,697.14</td>
                        </tr>
                        <tr>
                            <td>08/03/2024</td>
                            <td>320</td>
                            <td>DÉB INTERNET - SUPERMERCADO VALE VERDE</td>
                            <td class="amount debit">-210.33</td>
                            <td class="balance">28,486.81</td>
                        </tr>
                        <tr>
                            <td>09/03/2024</td>
                            <td>310</td>
                            <td>DÉB CARTÃO - MADISON FLORISTS</td>
                            <td class="amount debit">-127.00</td>
                            <td class="balance">28,359.81</td>
                        </tr>
                        <tr>
                            <td>09/03/2024</td>
                            <td>701</td>
                            <td>DEP DINHEIRO - ATM CENTRAL</td>
                            <td class="amount credit">+1,000.00</td>
                            <td class="balance">29,359.81</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <div class="financial-analysis">
                <div class="section-title">ANÁLISE DE FLUXO FINANCEIRO</div>
                <table class="analysis-table">
                    <thead>
                        <tr>
                            <th>Categoria</th>
                            <th>Valor ($)</th>
                            <th>Percentual</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Cassino/Jogos</td>
                            <td>29,000.00</td>
                            <td>59.4%</td>
                        </tr>
                        <tr>
                            <td>Moradia</td>
                            <td>2,400.00</td>
                            <td>4.9%</td>
                        </tr>
                        <tr>
                            <td>Alimentação</td>
                            <td>807.90</td>
                            <td>1.7%</td>
                        </tr>
                        <tr>
                            <td>Serviços básicos</td>
                            <td>579.52</td>
                            <td>1.2%</td>
                        </tr>
                        <tr>
                            <td>Outros</td>
                            <td>16,098.55</td>
                            <td>32.9%</td>
                        </tr>
                    </tbody>
                
                <div class="bar-chart">
                    <div class="bar-container">
                        <div class="bar-segment casino" style="width: 59.4%;">Cassino</div>
                        <div class="bar-segment housing" style="width: 4.9%;">Moradia</div>
                        <div class="bar-segment food" style="width: 1.7%;">Aliment.</div>
                        <div class="bar-segment utilities" style="width: 1.2%;">Serviços</div>
                        <div class="bar-segment other" style="width: 32.9%;">Outros</div>
                    </div>
                    <div class="chart-legend">
                        <div class="legend-item">
                            <div class="color-box casino"></div>
                            <span>Cassino/Jogos (59.4%)</span>
                        </div>
                        <div class="legend-item">
                            <div class="color-box housing"></div>
                            <span>Moradia (4.9%)</span>
                        </div>
                        <div class="legend-item">
                            <div class="color-box food"></div>
                            <span>Alimentação (1.7%)</span>
                        </div>
                        <div class="legend-item">
                            <div class="color-box utilities"></div>
                            <span>Serviços básicos (1.2%)</span>
                        </div>
                        <div class="legend-item">
                            <div class="color-box other"></div>
                            <span>Outros (32.9%)</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="alerts-section">
                <div class="section-title">ALERTAS DE SEGURANÇA</div>
                <div class="alerts-content">
                    <p>Sua conta apresenta padrão consistente de transferências para o estabelecimento "Lucky Star Casino" (total: $29,000.00 em período de 60 dias) que pode comprometer sua estabilidade financeira. Recomendamos contato com nosso departamento de Consultoria Financeira.</p>
                </div>
            </div>
            
            <div class="alerts-section">
                <div class="section-title">INFORMAÇÕES IMPORTANTES</div>
                <div class="alerts-content">
                    <div class="alerts-title">MOVIMENTAÇÕES ATÍPICAS DETECTADAS</div>
                    <ul class="alerts-list">
                        <li>Saques frequentes de valores elevados</li>
                        <li>Transferências recorrentes para estabelecimentos de jogos</li>
                        <li>Redução de 62% do patrimônio inicial obtido com a venda da propriedade familiar</li>
                    </ul>
                </div>
            </div>
            
            <div class="confidential-warning">
                ESTE DOCUMENTO TEM CARÁTER CONFIDENCIAL
                <br>
                <small>Uso exclusivo do correntista e para investigação oficial autorizada</small>
            </div>
            
            <div class="authentication">
                Documento gerado eletronicamente em 10/03/2024 às 09:35:47
                <br>
                Autenticação: FNBR2024031000478956123498
            </div>
            
            <div class="footer">
                <div class="footer-logo">FNB RAVENWOOD</div>
                <p>Av. Maple, 1250 | Ravenwood | Tel: (555) 123-4567</p>
            </div>
        </div>
        
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
        function downloadPDF() {
            const element = document.querySelector('.a4-page');
            const opt = {
                margin: 0,
                filename: 'extrato-bancario.pdf',
                image: { type: 'jpeg', quality: 1 },
                html2canvas: { scale: 2, useCORS: true },
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
            };
            
            // Esconde o botão de download temporariamente
            const downloadBtn = document.querySelector('.download-btn');
            downloadBtn.style.display = 'none';
            
            // Gera o PDF
            html2pdf().set(opt).from(element).save().then(() => {
                // Restaura o botão após o download
                setTimeout(() => {
                    downloadBtn.style.display = 'flex';
                }, 1000);
            });
        }
    </script>
    </div>
</body>
</html>