<?php
// Start session to manage authentication
session_start();

// Check if already authenticated or if the form was submitted
$authenticated = false;
$error = false;

if (isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true) {
    $authenticated = true;
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    // Here any non-empty password will be accepted
    if (strlen($_POST['password']) > 0) {
        $_SESSION['authenticated'] = true;
        $authenticated = true;
    } else {
        $error = true;
    }
}

// Array with information about suspects
$suspects = [
    'padre' => [
        'nome' => 'Reverend Michael Shaw',
        'imagem' => 'padre.jpg',
        'culpado' => false,
        'solucao' => '<p><strong>Reverend Michael Shaw</strong></p>
                      <p>Motive: Yes. Emma discovered the church fund embezzlement and the reverend’s extramarital affair.</p>
                      <p>Opportunity: No. His alibi is solid—confirmed by his wife and security cameras.</p>
                      <p>Means: No. No physical or technical evidence directly links Shaw to the crime.</p>'
    ],
    'prefeito' => [
        'nome' => 'Mayor Richard Grant',
        'imagem' => 'prefeito.jpg',
        'culpado' => false,
        'solucao' => '<p><strong>Mayor Richard Grant</strong></p>
                      <p>Motive: Yes. Emma had uncovered serious corruption schemes involving the mayor, including covering up the orphanage deaths.</p>
                      <p>Opportunity: No. His alibi is confirmed by multiple witnesses and the charity event evidence.</p>
                      <p>Means: No. No physical evidence links him directly to the crime.</p>'
    ],
    'james' => [
        'nome' => 'Dr. James Wilson',
        'imagem' => 'james.jpeg',
        'culpado' => true,
        'solucao' => '<div class="solucao-completa">
                      <h2>FULL SOLUTION</h2>
                      <p>Below is a detailed explanation of the case solution.</p>
                      
                      <p><strong>Reverend Michael Shaw</strong><br>
                      Motive: Yes. Emma discovered the church embezzlement and his affair.<br>
                      Opportunity: No. Solid alibi confirmed by wife and cameras.<br>
                      Means: No direct evidence linking him.</p>
                      
                      <p><strong>Mayor Richard Grant</strong><br>
                      Motive: Yes. Emma found his corruption and orphanage cover-up.<br>
                      Opportunity: No. Alibi confirmed by witnesses and event records.<br>
                      Means: No physical evidence linking him.</p>
                      
                      <p><strong>Dr. James Wilson</strong><br>
                      Motive: Yes. Emma was investigating illegal medical experiments he conducted at Santa Cruz Orphanage. His wife committed suicide upon discovering these cruel experiments. After her death, he made significant annual donations in her name to a children’s charity to atone. Emma was connecting these dots and threatened to expose him, which would ruin his reputation.<br>
                      Opportunity: Yes. His handwritten surgical notes do not prove continuous presence in his office during the relevant period—no eyewitness confirmation.<br>
                      Means: Yes. The crime used a medical technique. He also tried to frame Helen Brooks, who was investigating her sister’s death. By eliminating Emma and blaming Helen, he would remove both threats.</p>
                      
                      <p><strong>Helen Brooks</strong><br>
                      Motive: Yes. Emma was the daughter of the man responsible for the accident that killed Helen’s parents, and her sister died in the orphanage experiments.<br>
                      Opportunity: No. Cell-tower data confirms her phone never left home.<br>
                      Means: Maybe. She knows occult practices, but the symbols were executed incorrectly.</p>
                      
                      <p><strong>Daniel Collins</strong><br>
                      Motive: Yes. Inheritance disputes and gambling debts.<br>
                      Opportunity: No. Bar security footage and witnesses place him continuously at Lucky’s Bar.<br>
                      Means: No. No evidence he had the skillset for this specific crime.</p>
                      
                      <p><strong>Sarah Mitchell</strong><br>
                      Motive: Maybe. Jealousy and personal conflicts existed, but unlikely to drive murder.<br>
                      Opportunity: No. Alibi confirmed by emergency home medical care.<br>
                      Means: No evidence linking her to the method or location.</p>
                      
                      <p><strong>Sheriff Thomas Reed</strong><br>
                      Motive: Yes. Emma uncovered his ties to the local drug cartel.<br>
                      Opportunity: No. Patrol logs confirm his location on duty.<br>
                      Means: No proof directly linking him.</p>
                      
                      <h3>Final Conclusion</h3>
                      <p>Dr. James Wilson is the only suspect without a solid, independently confirmed alibi. His preparatory handwritten notes could have been pre-written. The medical technique matches his expertise. The incorrect occult symbols were a red herring to implicate Helen Brooks. All evidence points conclusively to Dr. James Wilson as Emma Collins’s murderer.</p>
                      </div>'
    ],
    'hellen' => [
        'nome' => 'Helen Brooks',
        'imagem' => 'hellen.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Helen Brooks</strong></p>
                      <p>Motive: Yes. Emma was the daughter of the man responsible for the accident that killed Helen’s parents, and her sister died in the experiments.</p>
                      <p>Opportunity: No. Cell-tower data confirms her phone never left home.</p>
                      <p>Means: Maybe. She knows occult practices, but the symbols were botched.</p>'
    ],
    'daniel' => [
        'nome' => 'Daniel Collins',
        'imagem' => 'daniel.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Daniel Collins</strong></p>
                      <p>Motive: Yes. Inheritance disputes and gambling debts.</p>
                      <p>Opportunity: No. Bar footage and witnesses confirm his presence.</p>
                      <p>Means: No evidence he had the skills for this crime.</p>'
    ],
    'sarah' => [
        'nome' => 'Sarah Mitchell',
        'imagem' => 'sarah.jpg',
        'culpado' => false,
        'solucao' => '<p><strong>Sarah Mitchell</strong></p>
                      <p>Motive: Maybe. Jealousy and personal conflicts, but unlikely to kill.</p>
                      <p>Opportunity: No. Alibi from emergency home care.</p>
                      <p>Means: No evidence linking her to the crime.</p>'
    ],
    'xerife' => [
        'nome' => 'Sheriff Thomas Reed',
        'imagem' => 'xerife.jpeg',
        'culpado' => false,
        'solucao' => '<p><strong>Sheriff Thomas Reed</strong></p>
                      <p>Motive: Yes. Emma discovered his cartel ties.</p>
                      <p>Opportunity: No. Patrol logs confirm his location.</p>
                      <p>Means: No direct link.</p>'
    ]
];

// Check if a suspect was selected
$selectedSuspect = null;
$isCorrect = false;

if ($authenticated && isset($_GET['suspect']) && array_key_exists($_GET['suspect'], $suspects)) {
    $selectedSuspect = $suspects[$_GET['suspect']];
    $isCorrect = $selectedSuspect['culpado'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Criminal Case: The Murder of Emma Collins</title>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Montserrat:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        :root {
            --primary: #8B0000;
            --primary-dark: #5C0000;
            --primary-light: #C41E3A;
            --primary-hover: #9D0000;
            --accent: #FFD700;
            --accent-dark: #DAA520;
            --text-light: #F5F5F5;
            --text-dark: #333333;
            --bg-dark: #1A1A1A;
            --bg-darker: #121212;
            --bg-light: #2A2A2A;
            --success: #4CAF50;
            --error: #FF5252;
            --card-shadow: rgba(0, 0, 0, 0.2);
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            --paper-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
            --paper-shadow-hover: 0 14px 28px rgba(0,0,0,0.25), 0 10px 10px rgba(0,0,0,0.22);
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Montserrat', sans-serif;
            background-color: var(--bg-darker);
            color: var(--text-light);
            line-height: 1.6;
            background-image: url('https://i.imgur.com/JxqL1Qz.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.75);
            z-index: -1;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        
        header {
            text-align: center;
            margin-bottom: 40px;
            border-bottom: 2px solid var(--primary);
            padding-bottom: 20px;
        }
        
        h1 {
            font-family: 'Playfair Display', serif;
            font-size: 3.5rem;
            color: var(--primary);
            margin-bottom: 15px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
        }
        
        h2 {
            font-family: 'Playfair Display', serif;
            font-size: 2.2rem;
            color: var(--accent);
            margin: 25px 0;
            text-align: center;
        }
        
        h3 {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            color: var(--accent);
            margin: 20px 0;
        }
        
        .subtitle {
            font-family: 'Montserrat', sans-serif;
            font-size: 1.2rem;
            font-weight: 300;
            color: var(--text-light);
            font-style: italic;
            margin-bottom: 30px;
        }
        
        /* Password form */
        .password-form {
            max-width: 450px;
            margin: 80px auto;
            padding: 35px;
            background: rgba(26, 26, 26, 0.95);
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5);
            border: 1px solid var(--primary);
            animation: fadeIn 1s;
        }
        
        .password-form h2 {
            margin-top: 0; font-size: 1.8rem;
        }
        
        .form-group { margin-bottom: 25px; }
        
        label {
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
            font-size: 1.1rem;
        }
        
        input[type="text"] {
            width: 100%;
            padding: 15px;
            background: var(--bg-darker);
            border: 1px solid var(--bg-light);
            border-radius: 5px;
            color: var(--text-light);
            font-size: 1.1rem;
            transition: var(--transition);
        }
        
        input[type="text"]:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 8px rgba(139, 0, 0, 0.5);
        }
        
        button {
            display: block;
            width: 100%;
            padding: 15px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 1.1rem;
            font-weight: 500;
            cursor: pointer;
            transition: var(--transition);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        button:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        
        .error-message {
            color: var(--error);
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            background: rgba(255, 82, 82, 0.1);
            border-radius: 4px;
            font-weight: 500;
        }
        
        /* Suspects grid */
        .suspects-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 25px;
            margin: 40px 0;
        }
        
        .suspect-card {
            background: rgba(42, 42, 42, 0.95);
            border-radius: 8px;
            overflow: hidden;
            transition: var(--transition);
            border: 1px solid var(--primary-dark);
            cursor: pointer;
            position: relative;
            animation: fadeInUp 0.8s;
            animation-fill-mode: both;
            box-shadow: var(--paper-shadow);
        }
        
        .suspects-grid .suspect-card:nth-child(1) { animation-delay: 0.1s; }
        .suspects-grid .suspect-card:nth-child(2) { animation-delay: 0.2s; }
        .suspects-grid .suspect-card:nth-child(3) { animation-delay: 0.3s; }
        .suspects-grid .suspect-card:nth-child(4) { animation-delay: 0.4s; }
        .suspects-grid .suspect-card:nth-child(5) { animation-delay: 0.5s; }
        .suspects-grid .suspect-card:nth-child(6) { animation-delay: 0.6s; }
        .suspects-grid .suspect-card:nth-child(7) { animation-delay: 0.7s; }
        
        .suspect-card:hover {
            transform: translateY(-10px) scale(1.02);
            box-shadow: var(--paper-shadow-hover);
            border-color: var(--primary);
        }
        
        .suspect-card::after {
            content: '';
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: linear-gradient(to bottom, transparent 70%, rgba(139, 0, 0, 0.7) 100%);
            opacity: 0;
            transition: var(--transition);
        }
        
        .suspect-card:hover::after { opacity: 1; }
        
        .suspect-card img {
            width: 100%;
            height: 300px;
            object-fit: cover;
            transition: var(--transition);
            display: block;
            filter: grayscale(30%);
        }
        
        .suspect-card:hover img {
            filter: grayscale(0%);
            transform: scale(1.05);
        }
        
        .suspect-info {
            padding: 15px;
            text-align: center;
            background: var(--primary-dark);
            position: relative;
            z-index: 2;
            transition: var(--transition);
        }
        
        .suspect-card:hover .suspect-info { background: var(--primary); }
        
        .suspect-name {
            font-family: 'Playfair Display', serif;
            font-size: 1.3rem;
            margin: 0; padding: 0;
            color: var(--text-light);
            position: relative;
        }
        
        .suspect-name::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 50%;
            transform: translateX(-50%);
            width: 0; height: 2px;
            background-color: var(--accent);
            transition: var(--transition);
        }
        
        .suspect-card:hover .suspect-name::after { width: 80%; }
        
        /* Result */
        .result-container {
            max-width: 900px;
            margin: 40px auto;
            padding: 40px;
            background: rgba(26, 26, 26, 0.95);
            border-radius: 10px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.5);
            animation: fadeIn 1s;
            border-left: 5px solid;
        }
        
        .result-correct { border-color: var(--success); }
        .result-incorrect { border-color: var(--error); }
        
        .result-header {
            display: flex; align-items: center;
            margin-bottom: 30px; padding-bottom: 20px;
            border-bottom: 1px solid var(--bg-light);
        }
        
        .result-img {
            width: 120px; height: 120px;
            border-radius: 50%;
            object-fit: cover;
            margin-right: 25px;
            border: 3px solid;
        }
        
        .result-correct .result-img { border-color: var(--success); }
        .result-incorrect .result-img { border-color: var(--error); }
        
        .result-title {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            margin-bottom: 10px;
        }
        
        .result-subtitle {
            font-size: 1.1rem; font-weight: 300;
            margin-bottom: 0;
        }
        
        .verdict {
            font-family: 'Playfair Display', serif;
            font-size: 1.5rem;
            margin: 30px 0;
            padding: 15px; border-radius: 5px;
            text-align: center;
        }
        
        .verdict-correct {
            background-color: rgba(76, 175, 80, 0.1);
            color: var(--success);
        }
        
        .verdict-incorrect {
            background-color: rgba(255, 82, 82, 0.1);
            color: var(--error);
        }
        
        .solution-content {
            line-height: 1.8; font-size: 1.1rem;
        }
        
        .solution-content p { margin-bottom: 20px; }
        .solution-content strong { color: var(--accent); }
        
        .back-button {
            display: inline-block;
            margin-top: 30px;
            padding: 12px 25px;
            background: var(--bg-light);
            color: var(--text-light);
            text-decoration: none;
            border-radius: 5px;
            transition: var(--transition);
            border: 1px solid var(--primary);
        }
        
        .back-button:hover {
            background: var(--primary);
            transform: translateY(-2px);
        }
        
        /* Additional animations and styles omitted for brevity */
    </style>
</head>
<body>
    <!-- Loading overlay -->
    <div class="loading-overlay" id="loading-overlay">
        <div class="loading-spinner"></div>
    </div>
    
    <div class="container">
        <header>
            <h1 class="animate__animated animate__fadeInDown">Criminal Case: The Murder of Emma Collins</h1>
            <p class="subtitle animate__animated animate__fadeIn animate__delay-1s">Discover the truth behind this mysterious crime</p>
        </header>
        
        <div class="watermark">Crime Files ©️ 2025</div>
        
        <?php if (!$authenticated): ?>
            <!-- Password form -->
            <div class="password-form">
                <div style="text-align: center;">
                    <span class="magnifying-glass">🔍</span>
                    <h2>Restricted Access</h2>
                </div>
                <p style="text-align: center; margin-bottom: 25px;">
                    The password is the E-mail you used for your Cartpanda purchase:
                </p>
                
                <?php if ($error): ?>
                    <div class="error-message animate__animated animate__shakeX">
                        Invalid CPF. Please try again.
                    </div>
                <?php endif; ?>
                
                <form method="post" action="">
                    <div class="form-group">
                        <label for="password">CPF:</label>
                        <input type="text" id="password" name="password" required autofocus maxlength="11" pattern="[0-9]*" inputmode="numeric" placeholder="Enter 11 digits without dashes or dots">
                        <p style="font-size: 0.8rem; margin-top: 8px; color: #aaa;">
                            Enter your 11-digit CPF without dashes or dots.
                        </p>
                    </div>
                    <button type="submit">Verify</button>
                </form>
            </div>
        
        <?php elseif ($selectedSuspect): ?>
            <!-- Suspect result -->
            <div class="result-container <?php echo $isCorrect ? 'result-correct' : 'result-incorrect'; ?>">
                <div class="result-header">
                    <img src="<?php echo htmlspecialchars($selectedSuspect['imagem']); ?>" alt="<?php echo htmlspecialchars($selectedSuspect['nome']); ?>" class="result-img">
                    <div>
                        <h2 class="result-title"><?php echo htmlspecialchars($selectedSuspect['nome']); ?></h2>
                        <p class="result-subtitle">Your investigation result</p>
                    </div>
                </div>
                
                <div class="verdict <?php echo $isCorrect ? 'verdict-correct' : 'verdict-incorrect'; ?>">
                    <?php if ($isCorrect): ?>
                        <span>✓</span> You are correct! This is the true culprit!
                    <?php else: ?>
                        <span>✗</span> This suspect is not the culprit. Keep investigating!
                    <?php endif; ?>
                </div>
                
                <div class="solution-content">
                    <?php echo $selectedSuspect['solucao']; ?>
                </div>
                
                <a href="?<?php echo time(); ?>" class="back-button">Back to Suspects</a>
            </div>
        
        <?php else: ?>
            <!-- Suspects grid -->
            <div style="text-align: center;">
                <h2 class="animate__animated animate__fadeIn">Select a Suspect</h2>
                <p class="animate__animated animate__fadeIn animate__delay-1s" style="max-width: 800px; margin: 0 auto 30px;">
                    After extensive investigation, choose the suspect you believe to be Emma Collins’s true killer:
                </p>
            </div>
            
            <div class="suspects-grid">
                <?php foreach ($suspects as $key => $suspect): ?>
                    <a href="?suspect=<?php echo htmlspecialchars($key); ?>" class="suspect-card">
                        <img src="<?php echo htmlspecialchars($suspect['imagem']); ?>" alt="<?php echo htmlspecialchars($suspect['nome']); ?>">
                        <div class="suspect-info">
                            <h3 class="suspect-name"><?php echo htmlspecialchars($suspect['nome']); ?></h3>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        // Hide loading overlay on page load
        window.addEventListener('load', function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                setTimeout(() => loadingOverlay.style.display = 'none', 500);
            }
        });
        
        // Show loading on link clicks and form submissions
        document.addEventListener('DOMContentLoaded', () => {
            const overlay = document.getElementById('loading-overlay');
            document.querySelectorAll('a:not([target="_blank"])').forEach(link => {
                link.addEventListener('click', () => {
                    if (!link.getAttribute('href').startsWith('#') && overlay) {
                        overlay.style.display = 'flex';
                        setTimeout(() => overlay.style.opacity = '1', 10);
                    }
                });
            });
            document.querySelectorAll('form').forEach(form => {
                form.addEventListener('submit', () => {
                    if (overlay) {
                        overlay.style.display = 'flex';
                        setTimeout(() => overlay.style.opacity = '1', 10);
                    }
                });
            });
        });
        
        <?php if ($isCorrect): ?>
        // Create confetti effect for correct answer
        function createConfetti() {
            const colors = ['#8B0000','#FFD700','#C41E3A','#DAA520','#4CAF50'];
            for (let i=0; i<150; i++) {
                const c = document.createElement('div');
                c.classList.add('confetti');
                c.style.left = Math.random()*100 + 'vw';
                c.style.animationDelay = Math.random()*5+'s';
                c.style.animationDuration = Math.random()*3+3+'s';
                c.style.backgroundColor = colors[Math.floor(Math.random()*colors.length)];
                if (Math.random()>.5) c.style.borderRadius = '50%';
                if (Math.random()>.5) { c.style.width='8px'; c.style.height='8px'; c.style.transform='rotate(45deg)'; }
                document.body.appendChild(c);
                setTimeout(()=>c.remove(),8000);
            }
        }
        setTimeout(createConfetti, 500);
        <?php endif; ?>
    </script>
</body>
</html>
