<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>O Mistério de Ravenwood - Investigação Criminal em Casa</title>
  
  <!-- Meta Pixel Code -->
  <script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src=v;s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script',
  'https://connect.facebook.net/en_US/fbevents.js');
  fbq('init', '699560595893408');
  fbq('init', '4190027631232035');
  fbq('track', 'PageView');
  </script>
  <noscript><img height="1" width="1" style="display:none"
  src="https://www.facebook.com/tr?id=699560595893408&ev=PageView&noscript=1"
  /></noscript>
  
  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Crimson+Text:wght@400;600;700&display=swap" rel="stylesheet">
  
  <!-- Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    :root {
      --primary: #DC143C;
      --primary-dark: #8B0000;
      --secondary: #1A1A1A;
      --gray-100: #F8F9FA;
      --gray-200: #E9ECEF;
      --gray-300: #DEE2E6;
      --gray-500: #ADB5BD;
      --gray-600: #6C757D;
      --gray-700: #495057;
      --gray-800: #343A40;
      --gray-900: #212529;
      --white: #FFFFFF;
      --success: #28A745;
      --warning: #FFD700;
      
      --font-primary: 'Inter', sans-serif;
      --font-accent: 'Crimson Text', serif;
      
      --shadow-sm: 0 2px 4px rgba(0,0,0,0.08);
      --shadow-md: 0 4px 12px rgba(0,0,0,0.1);
      --shadow-lg: 0 8px 24px rgba(0,0,0,0.12);
      
      --radius: 12px;
      --radius-lg: 20px;
    }
    
    html {
      scroll-behavior: smooth;
    }
    
    body {
      font-family: var(--font-primary);
      color: var(--gray-900);
      background: var(--white);
      line-height: 1.6;
    }
    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 20px;
      width: 100%;
    }
    
    @media (max-width: 768px) {
      .container {
        padding: 0 15px;
      }
    }
    
    @media (max-width: 480px) {
      .container {
        padding: 0 15px;
      }
    }
    
    /* Hero Section */
    .hero {
      background: linear-gradient(180deg, #FAFAFA 0%, #F5F5F5 100%);
      padding: 80px 0 60px;
      text-align: center;
    }
    
    .hero-title {
      font-family: var(--font-accent);
      font-size: clamp(2.5rem, 6vw, 4rem);
      font-weight: 700;
      color: var(--gray-900);
      margin-bottom: 1rem;
      line-height: 1.2;
    }
    
    .hero-title span {
      color: var(--primary);
    }
    
    .hero-subtitle {
      font-size: clamp(1.1rem, 2.5vw, 1.5rem);
      color: var(--gray-700);
      margin-bottom: 3rem;
      max-width: 700px;
      margin-left: auto;
      margin-right: auto;
    }
    
    .hero-image {
      margin: 3rem auto;
      position: relative;
      max-width: 400px;
    }
    
    .hero-image img {
      width: 100%;
      height: auto;
      border-radius: var(--radius-lg);
      box-shadow: 0 20px 40px rgba(0,0,0,0.15);
    }
    
    .hero-stats {
      display: flex;
      justify-content: center;
      gap: 2rem;
      margin: 2rem 0;
      flex-wrap: wrap;
      padding: 0 20px;
    }
    
    .stat-item {
      text-align: center;
      flex: 1;
      min-width: 80px;
    }
    
    .stat-value {
      font-size: clamp(1.5rem, 4vw, 2rem);
      font-weight: 700;
      color: var(--primary);
      display: block;
    }
    
    .stat-label {
      font-size: clamp(0.75rem, 2vw, 0.875rem);
      color: var(--gray-600);
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }
    
    /* Buttons */
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 16px 32px;
      font-weight: 600;
      font-size: clamp(0.9rem, 2.5vw, 1rem);
      border-radius: var(--radius);
      text-decoration: none;
      transition: all 0.3s ease;
      cursor: pointer;
      border: none;
      gap: 10px;
      min-height: 48px;
      -webkit-tap-highlight-color: transparent;
    }
    
    .btn-primary {
      background: var(--primary);
      color: white;
      box-shadow: 0 4px 14px rgba(220,20,60,0.25);
    }
    
    .btn-primary:hover {
      background: var(--primary-dark);
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(220,20,60,0.35);
    }
    
    .btn-large {
      padding: 20px 40px;
      font-size: clamp(1rem, 2.5vw, 1.1rem);
    }
    
    .security-badge {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
      margin-top: 1rem;
      color: var(--gray-600);
      font-size: clamp(0.75rem, 2vw, 0.875rem);
      padding: 0 20px;
      text-align: center;
      flex-wrap: wrap;
    }
    
    .security-badge i {
      color: var(--success);
    }
    
    /* Cases Section */
    .case-section {
      padding: 60px 0;
      background: var(--white);
    }
    
    .section-header {
      text-align: center;
      margin-bottom: 40px;
      padding: 0 20px;
    }
    
    .section-title {
      font-family: var(--font-accent);
      font-size: clamp(1.75rem, 5vw, 3rem);
      font-weight: 700;
      color: var(--gray-900);
      margin-bottom: 1rem;
    }
    
    .section-subtitle {
      font-size: clamp(1rem, 2.5vw, 1.125rem);
      color: var(--gray-600);
      max-width: 600px;
      margin: 0 auto;
      line-height: 1.6;
    }
    
    .case-content {
      max-width: 800px;
      margin: 0 auto;
      background: var(--gray-100);
      padding: clamp(20px, 5vw, 40px);
      border-radius: var(--radius-lg);
      box-shadow: var(--shadow-md);
    }
    
    .case-content p {
      font-size: clamp(1rem, 2.5vw, 1.1rem);
      line-height: 1.8;
      color: var(--gray-700);
      margin-bottom: 1.5rem;
    }
    
    .case-highlight {
      color: var(--primary);
      font-weight: 600;
    }
    
    .evidence-box {
      background: white;
      border-left: 4px solid var(--primary);
      padding: clamp(15px, 3vw, 20px);
      margin: 1.5rem 0;
      border-radius: var(--radius);
      box-shadow: var(--shadow-sm);
    }
    
    .evidence-box-title {
      font-weight: 700;
      color: var(--primary);
      margin-bottom: 0.5rem;
      display: flex;
      align-items: center;
      gap: 0.5rem;
      font-size: clamp(0.875rem, 2.5vw, 1rem);
    }
    
    .evidence-box p {
      font-size: clamp(0.9rem, 2.5vw, 1rem);
      margin-bottom: 0;
    }
    
    /* Como Funciona - Design Limpo */
    .how-section {
      padding: 70px 0;
      background: var(--gray-100);
    }
    
    .how-wrapper {
      max-width: 1000px;
      margin: 40px auto 0;
      padding: 0 20px;
      position: relative;
    }
    
    .how-wrapper::before {
      content: '';
      position: absolute;
      left: 50%;
      top: 0;
      bottom: 0;
      width: 2px;
      background: var(--primary);
      transform: translateX(-50%);
    }
    
    .how-step {
      display: flex;
      align-items: center;
      margin-bottom: 60px;
      position: relative;
      opacity: 0;
      animation: slideInUp 0.8s ease forwards;
    }
    
    .how-step:nth-child(1) { animation-delay: 0.1s; }
    .how-step:nth-child(2) { animation-delay: 0.2s; }
    .how-step:nth-child(3) { animation-delay: 0.3s; }
    .how-step:nth-child(4) { animation-delay: 0.4s; }
    
    @keyframes slideInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }
    
    .how-step.reverse {
      flex-direction: row-reverse;
    }
    
    .step-number {
      position: absolute;
      left: 50%;
      transform: translateX(-50%);
      width: 50px;
      height: 50px;
      background: var(--primary);
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.25rem;
      font-weight: 700;
      z-index: 10;
      border: 3px solid white;
      box-shadow: var(--shadow-md);
    }
    
    .step-content {
      flex: 1;
      background: white;
      padding: 30px;
      border-radius: var(--radius-lg);
      box-shadow: var(--shadow-md);
      margin-right: 60px;
      position: relative;
      transition: all 0.3s ease;
    }
    
    .how-step.reverse .step-content {
      margin-right: 0;
      margin-left: 60px;
    }
    
    .step-content:hover {
      transform: translateY(-3px);
      box-shadow: var(--shadow-lg);
    }
    
    .step-content::before {
      content: '';
      position: absolute;
      top: 50%;
      right: -20px;
      width: 0;
      height: 0;
      border-style: solid;
      border-width: 15px 0 15px 20px;
      border-color: transparent transparent transparent white;
      transform: translateY(-50%);
    }
    
    .how-step.reverse .step-content::before {
      right: auto;
      left: -20px;
      border-width: 15px 20px 15px 0;
      border-color: transparent white transparent transparent;
    }
    
    .step-icon {
      width: 60px;
      height: 60px;
      background: var(--primary);
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.5rem;
      margin-bottom: 20px;
      box-shadow: var(--shadow-sm);
    }
    
    .step-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--gray-900);
      margin-bottom: 15px;
    }
    
    .step-description {
      color: var(--gray-700);
      font-size: 1.125rem;
      line-height: 1.7;
      margin: 0;
    }
    
    .step-image {
      flex: 1;
      margin-left: 60px;
      border-radius: var(--radius-lg);
      overflow: hidden;
      box-shadow: var(--shadow-md);
    }
    
    .how-step.reverse .step-image {
      margin-left: 0;
      margin-right: 60px;
    }
    
    .step-gif, .step-static {
      width: 100%;
      height: 280px;
      object-fit: cover;
      border-radius: var(--radius-lg);
    }
    
    .how-cta {
      text-align: center;
      margin-top: 60px;
    }
    
    /* Mobile Responsive */
    @media (max-width: 768px) {
      .how-section {
        padding: 50px 0;
      }
      
      .how-wrapper {
        padding: 0 15px;
      }
      
      .how-wrapper::before {
        display: none;
      }
      
      .how-step {
        flex-direction: column;
        align-items: center;
        margin-bottom: 40px;
        text-align: center;
        background: white;
        padding: 30px 25px;
        border-radius: var(--radius-lg);
        box-shadow: var(--shadow-md);
      }
      
      .how-step.reverse {
        flex-direction: column;
      }
      
      .step-number {
        position: static;
        transform: none;
        margin-bottom: 20px;
        width: 40px;
        height: 40px;
        font-size: 1rem;
      }
      
      .step-content {
        margin: 0 !important;
        padding: 0;
        box-shadow: none;
        background: transparent;
        width: 100%;
      }
      
      .step-content::before {
        display: none;
      }
      
      .step-image {
        margin: 20px 0 0 0 !important;
        width: 100%;
        max-width: 300px;
      }
      
      .step-gif, .step-static {
        height: 180px;
      }
      
      .step-title {
        font-size: 1.3rem;
        margin-bottom: 10px;
      }
      
      .step-description {
        font-size: 0.95rem;
        margin-bottom: 15px;
      }
      
      .step-icon {
        width: 50px;
        height: 50px;
        font-size: 1.3rem;
        margin: 0 auto 15px;
      }
      
      .how-cta {
        margin-top: 40px;
      }
    }
    
    @media (max-width: 480px) {
      .how-step {
        padding: 25px 20px;
        margin-bottom: 30px;
      }
      
      .step-number {
        width: 35px;
        height: 35px;
        font-size: 0.9rem;
        margin-bottom: 15px;
      }
      
      .step-title {
        font-size: 1.1rem;
      }
      
      .step-description {
        font-size: 0.85rem;
      }
      
      .step-icon {
        width: 45px;
        height: 45px;
        font-size: 1.1rem;
        margin-bottom: 12px;
      }
      
      .step-gif, .step-static {
        height: 150px;
      }
      
      .how-cta {
        margin-top: 30px;
      }
    }
    
    /* Suspeitos Grid - Estilo Quadradinhos */
    .suspects-section {
      padding: 60px 0;
      background: white;
    }
    
    .suspects-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 20px;
      max-width: 900px;
      margin: 40px auto 0;
      padding: 0 20px;
    }
    
    .suspect-card {
      background: white;
      border-radius: var(--radius-lg);
      overflow: hidden;
      box-shadow: var(--shadow-md);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      display: flex;
      height: 200px;
    }
    
    .suspect-card:hover {
      transform: translateY(-5px);
      box-shadow: var(--shadow-lg);
    }
    
    .suspect-card.reverse {
      flex-direction: row-reverse;
    }
    
    .suspect-card.full-width {
      grid-column: 1 / -1;
      max-width: 600px;
      margin: 0 auto;
    }
    
    .suspect-image {
      width: 50%;
      height: 100%;
      object-fit: cover;
    }
    
    .suspect-info {
      width: 50%;
      padding: 30px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      background: var(--gray-100);
      position: relative;
    }
    
    .suspect-card.highlight .suspect-info {
      background: var(--primary);
      color: white;
    }
    
    .suspect-number {
      position: absolute;
      top: 15px;
      right: 15px;
      background: var(--primary);
      color: white;
      padding: 5px 15px;
      border-radius: 20px;
      font-weight: 600;
      font-size: 0.75rem;
    }
    
    .suspect-card.highlight .suspect-number {
      background: white;
      color: var(--primary);
    }
    
    .suspect-name {
      font-size: 1.25rem;
      font-weight: 700;
      margin-bottom: 5px;
      word-break: break-word;
      hyphens: auto;
    }
    
    .suspect-role {
      font-size: 0.875rem;
      opacity: 0.8;
      word-break: break-word;
      hyphens: auto;
    }
    
    .suspect-card.highlight .suspect-name,
    .suspect-card.highlight .suspect-role {
      color: white;
    }
    
    /* Mobile - Mantém quadradinhos para suspeitos */
    @media (max-width: 768px) {
      .suspects-section {
        padding: 60px 0;
      }
      
      .suspects-grid {
        gap: 15px;
        padding: 0 15px;
        margin-top: 40px;
      }
      
      .suspect-card {
        height: 150px;
      }
      
      .suspect-card.full-width {
        max-width: 100%;
      }
      
      .suspect-card.full-width .suspect-image {
        width: 40%;
      }
      
      .suspect-card.full-width .suspect-info {
        width: 60%;
      }
      
      .suspect-info {
        padding: 20px;
      }
      
      .suspect-name {
        font-size: 1rem;
      }
      
      .suspect-role {
        font-size: 0.75rem;
      }
      
      .suspect-number {
        font-size: 0.65rem;
        padding: 3px 10px;
        top: 10px;
        right: 10px;
      }
    }
    
    @media (max-width: 480px) {
      .suspects-grid {
        gap: 10px;
        padding: 0 10px;
      }
      
      .suspect-card {
        height: 120px;
      }
      
      .suspect-card.full-width {
        height: 100px;
        max-width: 100%;
      }
      
      .suspect-info {
        padding: 15px;
      }
      
      .suspect-name {
        font-size: 0.875rem;
        margin-bottom: 2px;
      }
      
      .suspect-role {
        font-size: 0.65rem;
      }
      
      .suspect-number {
        font-size: 0.6rem;
        padding: 2px 8px;
        top: 8px;
        right: 8px;
      }
    }
    
    @media (max-width: 360px) {
      .suspects-grid {
        gap: 8px;
        padding: 0 8px;
      }
      
      .suspect-card {
        height: 100px;
      }
      
      /* Ajuste especial para telas muito pequenas */
      .suspect-card.full-width {
        height: 80px;
      }
      
      .suspect-info {
        padding: 10px;
      }
      
      .suspect-name {
        font-size: 0.75rem;
        margin-bottom: 1px;
        line-height: 1.2;
      }
      
      .suspect-role {
        font-size: 0.6rem;
        line-height: 1.2;
      }
      
      .suspect-number {
        font-size: 0.5rem;
        padding: 2px 6px;
        top: 5px;
        right: 5px;
      }
    }
    
    @media (max-width: 320px) {
      .suspects-section {
        padding: 60px 0;
      }
      
      .suspects-grid {
        gap: 6px;
        padding: 0 6px;
      }
      
      .suspect-card {
        height: 80px;
      }
      
      .suspect-card.full-width {
        height: 70px;
      }
      
      .suspect-info {
        padding: 8px;
      }
      
      .suspect-name {
        font-size: 0.65rem;
      }
      
      .suspect-role {
        font-size: 0.55rem;
      }
      
      .suspect-number {
        display: none; /* Esconde número em telas muito pequenas */
      }
      

    }
    
    /* Materiais Section - Mais Compacta */
    .materials-section {
      padding: 50px 0;
      background: var(--gray-100);
    }
    
    .materials-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 25px;
      margin-top: 30px;
      padding: 0 20px;
      max-width: 1000px;
      margin-left: auto;
      margin-right: auto;
    }
    
    .material-card {
      background: white;
      border-radius: var(--radius-lg);
      padding: 25px 20px;
      text-align: center;
      box-shadow: var(--shadow-md);
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }
    
    .material-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 3px;
      background: var(--primary);
      transform: scaleX(0);
      transition: transform 0.3s ease;
    }
    
    .material-card:hover::before {
      transform: scaleX(1);
    }
    
    .material-card:hover {
      transform: translateY(-3px);
      box-shadow: var(--shadow-lg);
    }
    
    .material-icon {
      font-size: 2.2rem;
      color: var(--primary);
      margin-bottom: 15px;
      display: inline-block;
    }
    
    .material-title {
      font-size: 1.25rem;
      font-weight: 700;
      color: var(--gray-900);
      margin-bottom: 12px;
      line-height: 1.3;
    }
    
    .material-description {
      color: var(--gray-600);
      line-height: 1.6;
      margin-bottom: 18px;
      font-size: 0.95rem;
    }
    
    .material-features {
      list-style: none;
      text-align: left;
      max-width: 240px;
      margin: 0 auto;
    }
    
    .material-features li {
      display: flex;
      align-items: center;
      gap: 8px;
      padding: 5px 0;
      color: var(--gray-700);
      font-size: 0.9rem;
    }
    
    .material-features i {
      color: var(--success);
      font-size: 0.8rem;
      width: 14px;
      flex-shrink: 0;
    }
    
    @media (max-width: 768px) {
      .materials-grid {
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        padding: 0 15px;
      }
      
      .material-card {
        padding: 20px 15px;
      }
      
      .material-icon {
        font-size: 2rem;
        margin-bottom: 12px;
      }
      
      .material-title {
        font-size: 1.15rem;
        margin-bottom: 10px;
      }
      
      .material-description {
        font-size: 0.9rem;
        margin-bottom: 15px;
      }
      
      .material-features {
        max-width: 100%;
      }
      
      .material-features li {
        font-size: 0.85rem;
        padding: 4px 0;
      }
    }
    
    @media (max-width: 480px) {
      .materials-grid {
        grid-template-columns: 1fr;
        gap: 15px;
        margin-top: 25px;
      }
      
      .material-card {
        padding: 18px 15px;
      }
      
      .material-icon {
        font-size: 1.8rem;
        margin-bottom: 10px;
      }
      
      .material-title {
        font-size: 1.1rem;
        margin-bottom: 8px;
      }
      
      .material-description {
        font-size: 0.85rem;
        margin-bottom: 12px;
      }
      
      .material-features li {
        font-size: 0.8rem;
        gap: 6px;
      }
      
      .material-features i {
        font-size: 0.75rem;
        width: 12px;
      }
    }
    
    /* Depoimentos */
    .testimonials-section {
      padding: 60px 0;
      background: white;
    }
    
    .testimonials-wrapper {
      max-width: 1000px;
      margin: 40px auto 0;
      position: relative;
      padding: 0 20px;
    }
    
    /* Desktop testimonials */
    .desktop-testimonials {
      display: block;
    }
    
    .mobile-testimonials {
      display: none;
    }
    
    .testimonials-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 30px;
    }
    
    .testimonial-card {
      background: var(--gray-100);
      padding: 30px;
      border-radius: var(--radius-lg);
      text-align: center;
      transition: all 0.3s ease;
    }
    
    /* Mobile testimonials carousel */
    @media (max-width: 768px) {
      .desktop-testimonials {
        display: none;
      }
      
      .mobile-testimonials {
        display: block;
      }
      
      .mobile-carousel-container {
        overflow: hidden;
        border-radius: var(--radius-lg);
      }
      
      .mobile-carousel-track {
        display: flex;
        transition: transform 0.4s ease;
        width: 200%; /* 2 slides x 100% */
      }
      
      .mobile-testimonial-slide {
        width: 50%; /* Cada slide ocupa 50% do track (100% / 2 slides) */
        flex-shrink: 0;
        padding: 0 10px;
      }
      
      .mobile-testimonial-slide .testimonial-card {
        margin: 0;
        padding: 30px 20px;
      }
      
      .mobile-carousel-nav {
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 20px;
        margin-top: 30px;
      }
      
      .carousel-nav-btn {
        width: 45px;
        height: 45px;
        border-radius: 50%;
        border: none;
        background: var(--primary);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 1rem;
        box-shadow: var(--shadow-sm);
      }
      
      .carousel-nav-btn:hover {
        background: var(--primary-dark);
      }
      
      .carousel-dots {
        display: flex;
        gap: 10px;
      }
      
      .carousel-dot {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background: var(--gray-300);
        cursor: pointer;
        transition: all 0.3s ease;
      }
      
      .carousel-dot.active {
        background: var(--primary);
        transform: scale(1.2);
      }
    }
    
    @media (max-width: 480px) {
      .mobile-testimonial-slide {
        padding: 0 5px;
      }
      
      .mobile-testimonial-slide .testimonial-card {
        padding: 25px 15px;
      }
      
      .carousel-nav-btn {
        width: 40px;
        height: 40px;
        font-size: 0.9rem;
      }
      
      .mobile-carousel-nav {
        gap: 15px;
        margin-top: 25px;
      }
      
      .carousel-dot {
        width: 10px;
        height: 10px;
      }
    }
    
    .testimonial-card:hover {
      transform: translateY(-5px);
      box-shadow: var(--shadow-lg);
    }
    
    .testimonial-avatar {
      width: 80px;
      height: 80px;
      border-radius: 50%;
      margin: 0 auto 20px;
    }
    
    .testimonial-rating {
      color: var(--warning);
      margin-bottom: 15px;
    }
    
    .testimonial-quote {
      font-size: 1.125rem;
      color: var(--gray-700);
      line-height: 1.8;
      margin-bottom: 20px;
      font-style: italic;
    }
    
    .testimonial-author {
      font-weight: 700;
      color: var(--gray-900);
    }
    
    .testimonial-date {
      font-size: 0.875rem;
      color: var(--gray-500);
    }
    
    /* Purchase Section */
    .purchase-section {
      padding: 60px 0;
      background: var(--gray-100);
    }
    
    .purchase-wrapper {
      max-width: 900px;
      margin: 0 auto;
      background: white;
      border-radius: var(--radius-lg);
      padding: clamp(30px, 6vw, 60px);
      box-shadow: var(--shadow-lg);
      text-align: center;
    }
    
    .product-showcase {
      margin-bottom: 30px;
    }
    
    .product-image {
      width: 100%;
      max-width: 400px;
      border-radius: var(--radius-lg);
      box-shadow: var(--shadow-md);
      margin-bottom: 20px;
    }
    
    .product-title {
      font-family: var(--font-accent);
      font-size: clamp(1.5rem, 4vw, 2rem);
      font-weight: 700;
      color: var(--gray-900);
      margin-bottom: 10px;
    }
    
    .product-subtitle {
      color: var(--gray-600);
      font-size: clamp(1rem, 2.5vw, 1.125rem);
      margin-bottom: 20px;
    }
    
    .price-box {
      background: var(--gray-100);
      border-radius: var(--radius);
      padding: 20px;
      margin: 20px 0;
      text-align: center;
    }
    
    .price-wrapper {
      display: flex;
      align-items: baseline;
      justify-content: center;
      gap: 15px;
      margin-bottom: 10px;
    }
    
    .price-old {
      color: var(--gray-500);
      text-decoration: line-through;
      font-size: 1.5rem;
    }
    
    .price-current {
      font-size: 3rem;
      font-weight: 800;
      color: var(--primary);
    }
    
    .price-installment {
      color: var(--gray-600);
      font-size: 1rem;
    }
    
    /* Single Purchase Card */
    .single-purchase-card {
      background: var(--gray-100);
      border: 2px solid transparent;
      border-radius: var(--radius-lg);
      padding: 40px;
      margin-bottom: 30px;
      transition: all 0.3s ease;
      text-align: center;
    }
    
    .single-purchase-card:hover {
      border-color: var(--primary);
      transform: translateY(-3px);
      box-shadow: var(--shadow-lg);
    }
    
    .purchase-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--gray-900);
      margin-bottom: 25px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
    }
    
    .purchase-title i {
      font-size: 1.3rem;
      color: var(--primary);
    }
    
    .option-features {
      list-style: none;
      text-align: left;
      margin-bottom: 30px;
      max-width: 400px;
      margin-left: auto;
      margin-right: auto;
      margin-bottom: 30px;
    }
    
    .option-features li {
      display: flex;
      align-items: center;
      gap: 12px;
      padding: 10px 0;
      color: var(--gray-700);
      font-size: 1rem;
    }
    
    .option-features i {
      color: var(--success);
      font-size: 0.9rem;
      width: 16px;
      flex-shrink: 0;
    }
    
    .payment-methods {
      display: flex;
      justify-content: center;
      gap: 15px;
      margin-top: 30px;
      flex-wrap: wrap;
    }
    
    .payment-icon {
      padding: 10px 20px;
      background: var(--gray-100);
      border-radius: var(--radius);
      color: var(--gray-600);
      font-size: 1.5rem;
    }
    
    /* FAQ */
    .faq-section {
      padding: 80px 0;
      background: white;
    }
    
    .faq-container {
      max-width: 800px;
      margin: 0 auto;
    }
    
    .faq-item {
      background: var(--gray-100);
      border-radius: var(--radius);
      margin-bottom: 20px;
      overflow: hidden;
    }
    
    .faq-question {
      padding: 25px 30px;
      cursor: pointer;
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-weight: 600;
      color: var(--gray-900);
      transition: all 0.3s ease;
    }
    
    .faq-question:hover {
      background: var(--gray-200);
    }
    
    .faq-question i {
      color: var(--primary);
      transition: transform 0.3s ease;
    }
    
    .faq-item.active .faq-question i {
      transform: rotate(180deg);
    }
    
    .faq-answer {
      padding: 0 30px;
      max-height: 0;
      overflow: hidden;
      transition: all 0.3s ease;
    }
    
    .faq-item.active .faq-answer {
      padding: 0 30px 25px;
      max-height: 300px;
    }
    
    /* Footer */
    .footer {
      background: var(--gray-900);
      color: white;
      padding: 50px 0 30px;
      text-align: center;
    }
    
    .footer-logo {
      font-family: var(--font-accent);
      font-size: 1.5rem;
      font-weight: 700;
      margin-bottom: 20px;
    }
    
    .footer-links {
      display: flex;
      justify-content: center;
      gap: 30px;
      margin-bottom: 30px;
      flex-wrap: wrap;
    }
    
    .footer-links a {
      color: var(--gray-400);
      text-decoration: none;
      transition: color 0.3s ease;
    }
    
    .footer-links a:hover {
      color: white;
    }
    
    .footer-social {
      display: flex;
      justify-content: center;
      gap: 20px;
      margin-bottom: 30px;
    }
    
    .social-link {
      width: 40px;
      height: 40px;
      background: rgba(255,255,255,0.1);
      color: white;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 50%;
      transition: all 0.3s ease;
    }
    
    .social-link:hover {
      background: var(--primary);
      transform: translateY(-3px);
    }
    
    .footer-bottom {
      padding-top: 30px;
      border-top: 1px solid rgba(255,255,255,0.1);
      color: var(--gray-500);
      font-size: 0.875rem;
    }
    
    /* Float Buttons */
    .float-buttons {
      position: fixed;
      bottom: 30px;
      right: 30px;
      display: flex;
      flex-direction: column;
      gap: 15px;
      z-index: 1000;
    }
    
    .float-btn {
      width: 60px;
      height: 60px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-size: 30px;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: var(--shadow-lg);
      text-decoration: none;
    }
    

    
    .scroll-top-btn {
      background: var(--primary);
      opacity: 0;
      visibility: hidden;
      transition: all 0.3s ease;
    }
    
    .scroll-top-btn.visible {
      opacity: 1;
      visibility: visible;
    }
    
    /* Responsive - Mobile First Approach */
    @media (max-width: 768px) {
      /* Hero adjustments */
      .hero {
        padding: 60px 0 40px;
      }
      
      .hero::before {
        width: 500px;
        height: 500px;
        right: -50%;
      }
      
      .hero-image {
        max-width: 300px;
        margin: 1.5rem auto;
      }
      
      .hero-stats {
        gap: 1.5rem;
      }
      
      /* Sections */
      .case-section,
      .how-section,
      .suspects-section,
      .materials-section,
      .testimonials-section,
      .purchase-section,
      .faq-section {
        padding: 50px 0;
      }
      
      .section-header {
        margin-bottom: 30px;
      }
      
      /* Buttons */
      .btn {
        width: 100%;
        max-width: 300px;
      }
      
      .btn-large {
        padding: 16px 30px;
      }
      
      /* Testimonials */
      .testimonials-grid {
        grid-template-columns: 1fr;
      }
      
      /* Materials */
      .materials-grid {
        grid-template-columns: 1fr;
        gap: 20px;
      }
      
      .material-card {
        padding: 30px 20px;
      }
      
      /* Purchase */
      .purchase-wrapper {
        padding: 40px 20px;
        border-radius: var(--radius);
      }
      

      
      .single-purchase-card {
        padding: 30px 20px;
      }
      
      .purchase-title {
        font-size: 1.3rem;
        margin-bottom: 20px;
      }
      
      .option-features {
        margin-bottom: 25px;
      }
      
      .option-features li {
        font-size: 0.95rem;
        padding: 8px 0;
      }
      
      /* FAQ */
      .faq-question {
        padding: 20px;
        font-size: 0.95rem;
      }
      
      .faq-answer {
        padding: 0 20px;
      }
      
      .faq-item.active .faq-answer {
        padding: 0 20px 20px;
      }
      
      /* Footer */
      .footer-links {
        flex-direction: column;
        gap: 15px;
      }
      
      /* Float buttons */
      .float-buttons {
        bottom: 20px;
        right: 20px;
        gap: 10px;
      }
      
      .float-btn {
        width: 50px;
        height: 50px;
        font-size: 24px;
      }
    }
    
    @media (max-width: 480px) {
      /* Typography scale down */
      html {
        font-size: 14px;
      }
      
      /* Hero */
      .hero {
        padding: 40px 0 30px;
      }
      
      .hero-title {
        font-size: 1.75rem;
        margin-bottom: 0.75rem;
      }
      
      .hero-subtitle {
        margin-bottom: 1.5rem;
      }
      
      .hero-image {
        max-width: 280px;
      }
      
      .hero-stats {
        gap: 1rem;
      }
      
      /* Sections */
      .section-title {
        font-size: 1.5rem;
      }
      
      .section-subtitle {
        font-size: 0.95rem;
      }
      
      /* Case content */
      .case-content {
        padding: 20px 15px;
        margin: 0 10px;
      }
      
      /* Materials */
      .material-icon {
        font-size: 2.5rem;
      }
      
      .material-title {
        font-size: 1.25rem;
      }
      
      /* Purchase */
      .product-image {
        max-width: 100%;
      }
      
      .product-title {
        font-size: 1.5rem;
      }
      
      .price-current {
        font-size: 2.5rem;
      }
      

      
      .single-purchase-card {
        padding: 25px 15px;
      }
      
      .purchase-title {
        font-size: 1.2rem;
        margin-bottom: 15px;
        gap: 8px;
      }
      
      .option-features li {
        font-size: 0.9rem;
        padding: 6px 0;
      }
      
      /* Payment methods */
      .payment-methods {
        gap: 10px;
      }
      
      .payment-icon {
        padding: 8px 15px;
        font-size: 1.2rem;
      }
    }
    
    @media (max-width: 360px) {
      /* Ultra small devices */
      .container {
        padding: 0 10px;
      }
      
      /* Hero */
      .hero-title {
        font-size: 1.5rem;
      }
      
      .hero-subtitle {
        font-size: 0.9rem;
      }
      
      .hero-image {
        max-width: 260px;
        padding: 0 10px;
      }
      
      /* Buttons */
      .btn {
        padding: 14px 20px;
        font-size: 0.875rem;
      }
      
      .btn-large {
        padding: 14px 25px;
      }
      
      /* Sections */
      .case-section,
      .how-section,
      .suspects-section,
      .materials-section,
      .testimonials-section,
      .purchase-section,
      .faq-section {
        padding: 40px 0;
      }
      
      /* Float buttons */
      .float-btn {
        width: 45px;
        height: 45px;
        font-size: 20px;
      }
    }
  </style>
</head>
<body>
  <!-- Hero Section -->
  <section class="hero">
    <div class="container">
      <h1 class="hero-title">
        Viva a experiência de uma investigação criminal
        <span>na sua casa</span>
      </h1>
      <p class="hero-subtitle">
        Forme sua Equipe, Mergulhe nas Pistas, Descubra a Verdade
      </p>
      
      <div class="hero-image">
        <img src="imagens/emma_cartaz.png" alt="O Mistério de Ravenwood">
      </div>
      
      <div class="hero-stats">
        <div class="stat-item">
          <span class="stat-value">1-8</span>
          <span class="stat-label">Jogadores</span>
        </div>
        <div class="stat-item">
          <span class="stat-value">2-3h</span>
          <span class="stat-label">Duração</span>
        </div>
        <div class="stat-item">
          <span class="stat-value">4.9</span>
          <span class="stat-label">Avaliação</span>
        </div>
      </div>
      
      <a href="#comprar" class="btn btn-primary btn-large">
        <i class="fas fa-search"></i>
        Quero resolver este caso agora
      </a>
      
      <div class="security-badge">
        <i class="fas fa-lock"></i>
        PAGAMENTO 100% SEGURO COM ACESSO IMEDIATO
      </div>
    </div>
  </section>

  <!-- O Caso Section -->
  <section id="caso" class="case-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">O Crime</h2>
        <p class="section-subtitle">Um assassinato brutal que esconde segredos sombrios</p>
      </div>
      
      <div class="case-content">
        <p>
          <span class="case-highlight">Emma Collins, 28 anos, jornalista investigativa</span>, 
          foi encontrada morta na igreja abandonada de Santa Helena. Símbolos ocultistas 
          cercavam o corpo e um pendrive em sua mão continha arquivos sobre uma sociedade secreta.
        </p>
        
        <div class="evidence-box">
          <div class="evidence-box-title">
            <i class="fas fa-exclamation-triangle"></i>
            ÚLTIMA MENSAGEM
          </div>
          <p>
            "Eles sabem que eu sei. Preciso expor a verdade antes que seja tarde demais."
          </p>
        </div>
        
        <p>
          Emma estava prestes a publicar reportagens explosivas sobre corrupção em Ravenwood. 
          <span class="case-highlight">Sete suspeitos, sete motivos.</span> 
          Quem a silenciou para sempre?
        </p>
        
        <div style="display: flex; justify-content: center; align-items: center; margin-top: 40px; width: 100%; text-align: center;">
          <a href="#comprar" class="btn btn-primary btn-large">
            <i class="fas fa-user-secret"></i>
            Quero desvendar o mistério agora
          </a>
        </div>
      </div>
    </div>
  </section>

  <!-- Como Funciona Section -->
  <section class="how-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Como funciona?</h2>
        <p class="section-subtitle">Veja como é simples jogar direto da sua casa</p>
      </div>
      
      <div class="how-wrapper">
        <!-- Passo 1 -->
        <div class="how-step">
          <div class="step-number">01</div>
          <div class="step-content">
            <div class="step-icon">
              <i class="fas fa-download"></i>
            </div>
            <h3 class="step-title">Compre e Baixe</h3>
            <p class="step-description">
              Adquira o jogo e receba acesso imediato para download. 
              Tudo pronto em poucos minutos!
            </p>
          </div>
        </div>

        <!-- Passo 2 -->
        <div class="how-step">
          <div class="step-number">02</div>
          <div class="step-content">
            <div class="step-icon">
              <i class="fas fa-users"></i>
            </div>
            <h3 class="step-title">Reúna Sua Equipe</h3>
            <p class="step-description">
              Forme seu time de investigadores (1-8 pessoas) 
              e prepare-se para uma noite inesquecível.
            </p>
          </div>
          <div class="step-image">
            <img src="casaljogando1.gif" alt="Pessoas jogando" class="step-gif">
          </div>
        </div>

        <!-- Passo 3 -->
        <div class="how-step reverse">
          <div class="step-number">03</div>
          <div class="step-content">
            <div class="step-icon">
              <i class="fas fa-search"></i>
            </div>
            <h3 class="step-title">Investigue as Evidências</h3>
            <p class="step-description">
              Analise documentos sigilosos, laudos forenses e pistas 
              espalhadas pela internet. Cada detalhe importa!
            </p>
          </div>
          <div class="step-image">
            <img src="imagens/evidencias.png" alt="Evidências" class="step-static">
          </div>
        </div>

        <!-- Passo 4 -->
        <div class="how-step">
          <div class="step-number">04</div>
          <div class="step-content">
            <div class="step-icon">
              <i class="fas fa-lightbulb"></i>
            </div>
            <h3 class="step-title">Desvende o Mistério</h3>
            <p class="step-description">
              Conecte as pistas, discuta teorias e revele 
              a verdade por trás do assassinato de Emma Collins.
            </p>
          </div>
        </div>
      </div>
      
      <div class="how-cta">
        <a href="#comprar" class="btn btn-primary btn-large">
          <i class="fas fa-play"></i>
          Começar minha investigação
        </a>
      </div>
    </div>
  </section>

  <!-- Suspeitos Section -->
  <section id="suspeitos" class="suspects-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Os Suspeitos</h2>
        <p class="section-subtitle">Sete pessoas, sete motivos, um assassino</p>
      </div>
      
      <div class="suspects-grid">
        <div class="suspect-card">
          <img src="suspeitos/richard.jpeg" alt="Richard Grant" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #1</div>
            <h3 class="suspect-name">Richard Grant</h3>
            <p class="suspect-role">Prefeito de Ravenwood</p>
          </div>
        </div>

        <div class="suspect-card reverse">
          <img src="suspeitos/michael.jpeg" alt="Michael Shaw" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #2</div>
            <h3 class="suspect-name">Michael Shaw</h3>
            <p class="suspect-role">Reverendo</p>
          </div>
        </div>

        <div class="suspect-card highlight">
          <img src="suspeitos/james.jpeg" alt="James Wilson" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #3</div>
            <h3 class="suspect-name">Dr. James Wilson</h3>
            <p class="suspect-role">Médico Chefe</p>
          </div>
        </div>

        <div class="suspect-card reverse">
          <img src="suspeitos/helen.jpeg" alt="Helen Brooks" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #4</div>
            <h3 class="suspect-name">Helen Brooks</h3>
            <p class="suspect-role">Historiadora</p>
          </div>
        </div>

        <div class="suspect-card">
          <img src="suspeitos/daniel.jpeg" alt="Daniel Collins" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #5</div>
            <h3 class="suspect-name">Daniel Collins</h3>
            <p class="suspect-role">Irmão da Vítima</p>
          </div>
        </div>

        <div class="suspect-card reverse highlight">
          <img src="suspeitos/sarah.jpeg" alt="Sarah Mitchell" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #6</div>
            <h3 class="suspect-name">Sarah Mitchell</h3>
            <p class="suspect-role">Melhor Amiga</p>
          </div>
        </div>

        <div class="suspect-card full-width">
          <img src="suspeitos/thomas.jpeg" alt="Thomas Reed" class="suspect-image">
          <div class="suspect-info">
            <div class="suspect-number">SUSPEITO #7</div>
            <h3 class="suspect-name">Thomas Reed</h3>
            <p class="suspect-role">Xerife</p>
          </div>
        </div>
      </div>
      
      <div style="display: flex; justify-content: center; align-items: center; margin-top: 50px; width: 100%; text-align: center;">
        <a href="#comprar" class="btn btn-primary btn-large">
          <i class="fas fa-search-plus"></i>
          Descobrir quem é o culpado
        </a>
      </div>
    </div>
  </section>

  <!-- Materiais Section -->
  <section id="materiais" class="materials-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Materiais de Investigação</h2>
        <p class="section-subtitle">Tudo que você precisa para resolver o caso</p>
      </div>
      
      <div class="materials-grid">
        <div class="material-card">
          <i class="fas fa-file-contract material-icon"></i>
          <h3 class="material-title">Relatórios Policiais</h3>
          <p class="material-description">
            Documentos oficiais da investigação, laudos forenses e 
            análises detalhadas da cena do crime.
          </p>
          <ul class="material-features">
            <li><i class="fas fa-check"></i> Fotos exclusivas da cena</li>
            <li><i class="fas fa-check"></i> Laudos periciais completos</li>
            <li><i class="fas fa-check"></i> Timeline dos acontecimentos</li>
          </ul>
        </div>

        <div class="material-card">
          <i class="fas fa-microphone-alt material-icon"></i>
          <h3 class="material-title">Depoimentos Completos</h3>
          <p class="material-description">
            Transcrições integrais dos interrogatórios com todos os 
            suspeitos e testemunhas do caso.
          </p>
          <ul class="material-features">
            <li><i class="fas fa-check"></i> 7 interrogatórios completos</li>
            <li><i class="fas fa-check"></i> Contradições destacadas</li>
            <li><i class="fas fa-check"></i> Perfis psicológicos</li>
          </ul>
        </div>

        <div class="material-card">
          <i class="fas fa-search material-icon"></i>
          <h3 class="material-title">Evidências e Pistas</h3>
          <p class="material-description">
            Provas físicas, mensagens secretas e pistas cruciais 
            para desvendar o mistério.
          </p>
          <ul class="material-features">
            <li><i class="fas fa-check"></i> Mensagens criptografadas</li>
            <li><i class="fas fa-check"></i> Documentos secretos</li>
            <li><i class="fas fa-check"></i> Mapa de conexões</li>
          </ul>
        </div>
      </div>
      
      <div style="display: flex; justify-content: center; align-items: center; margin-top: 50px; width: 100%; text-align: center;">
        <a href="#comprar" class="btn btn-primary btn-large">
          <i class="fas fa-file-download"></i>
          Quero ter acesso a todos os materiais
        </a>
      </div>
    </div>
  </section>

  <!-- Depoimentos Section -->
  <section class="testimonials-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Depoimentos de quem jogou</h2>
        <p class="section-subtitle">Experiências reais de grupos que desvendaram o mistério</p>
      </div>
      
      <!-- Desktop: grid normal -->
      <div class="testimonials-wrapper desktop-testimonials">
        <div class="testimonials-grid">
          <div class="testimonial-card">
            <img src="avatares/julia.jpg" alt="Julia" class="testimonial-avatar">
            <div class="testimonial-rating">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <p class="testimonial-quote">
              "Nossa noite foi incrível! Nos sentimos como verdadeiros detetives 
              desvendando os segredos de Ravenwood. As pistas são desafiadoras 
              e o final surpreendente!"
            </p>
            <p class="testimonial-author">Julia e Pedro</p>
            <p class="testimonial-date">12 de março de 2025</p>
          </div>

          <div class="testimonial-card">
            <img src="avatares/samuel.jpg" alt="Samuel" class="testimonial-avatar">
            <div class="testimonial-rating">
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
              <i class="fas fa-star"></i>
            </div>
            <p class="testimonial-quote">
              "A qualidade do material é impressionante! Cada documento parece 
              autêntico e as teorias que criamos durante a noite aproximaram 
              a gente muito mais."
            </p>
            <p class="testimonial-author">Samuel e Amanda</p>
            <p class="testimonial-date">5 de março de 2025</p>
          </div>
        </div>
      </div>
      
      <!-- Mobile: carrossel -->
      <div class="mobile-testimonials">
        <div class="mobile-carousel-container">
          <div class="mobile-carousel-track" id="carouselTrack">
            
            <div class="mobile-testimonial-slide">
              <div class="testimonial-card">
                <img src="avatares/julia.jpg" alt="Julia" class="testimonial-avatar">
                <div class="testimonial-rating">
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-quote">
                  "Nossa noite foi incrível! Nos sentimos como verdadeiros detetives 
                  desvendando os segredos de Ravenwood. As pistas são desafiadoras 
                  e o final surpreendente!"
                </p>
                <p class="testimonial-author">Julia e Pedro</p>
                <p class="testimonial-date">12 de março de 2025</p>
              </div>
            </div>
            
            <div class="mobile-testimonial-slide">
              <div class="testimonial-card">
                <img src="avatares/samuel.jpg" alt="Samuel" class="testimonial-avatar">
                <div class="testimonial-rating">
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-quote">
                  "A qualidade do material é impressionante! Cada documento parece 
                  autêntico e as teorias que criamos durante a noite aproximaram 
                  a gente muito mais."
                </p>
                <p class="testimonial-author">Samuel e Amanda</p>
                <p class="testimonial-date">5 de março de 2025</p>
              </div>
            </div>
            
          </div>
        </div>
        
        <div class="mobile-carousel-nav">
          <button class="carousel-nav-btn" onclick="moveCarousel(-1)">
            <i class="fas fa-chevron-left"></i>
          </button>
          <div class="carousel-dots">
            <span class="carousel-dot active" onclick="goToSlide(0)"></span>
            <span class="carousel-dot" onclick="goToSlide(1)"></span>
          </div>
          <button class="carousel-nav-btn" onclick="moveCarousel(1)">
            <i class="fas fa-chevron-right"></i>
          </button>
        </div>
      </div>
        
        <div style="display: flex; justify-content: center; align-items: center; margin-top: 50px; width: 100%; text-align: center;">
          <a href="#comprar" class="btn btn-primary btn-large">
            <i class="fas fa-heart"></i>
            Quero viver essa experiência incrível
          </a>
        </div>
      </div>
    </div>
  </section>

  <!-- Comprar Section -->
  <section id="comprar" class="purchase-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Garanta Sua Experiência</h2>
        <p class="section-subtitle">Escolha a melhor opção para você</p>
      </div>
      
      <div class="purchase-wrapper">
        <div class="product-showcase">
          <img src="caso_emma_img.png" alt="Mistério de Ravenwood" class="product-image">
          <h3 class="product-title">O Mistério de Ravenwood</h3>
          <p class="product-subtitle">O Caso Emma Collins - Para 1-8 Jogadores</p>
        </div>
        
        <!-- Card de Compra Digital -->
        <div class="single-purchase-card">
          <h4 class="purchase-title">
            <i class="fas fa-file-pdf"></i> Versão Digital
          </h4>
          
          <div class="price-box">
            <div class="price-wrapper">
              <span class="price-old">De R$ 149,90</span>
              <span class="price-current">R$ 49,90</span>
            </div>
            <p class="price-installment">ou 6x de R$ 8,99 sem juros</p>
          </div>
          
          <ul class="option-features">
            <li><i class="fas fa-check"></i> Download instantâneo em PDF</li>
            <li><i class="fas fa-check"></i> Jogue no celular ou computador</li>
            <li><i class="fas fa-check"></i> Opção de imprimir em casa</li>
            <li><i class="fas fa-check"></i> Acesso vitalício</li>
          </ul>
          
          <a href="https://pay.kirvano.com/54706342-3777-496e-9836-81d7d15a002a" class="btn btn-primary" style="width: 100%;">
            QUERO A VERSÃO DIGITAL
          </a>
        </div>
        
        <div class="payment-methods">
          <div class="payment-icon">
            <i class="fas fa-credit-card"></i>
          </div>
          <div class="payment-icon">
            <i class="fas fa-barcode"></i>
          </div>
          <div class="payment-icon">
            <i class="fab fa-pix"></i>
          </div>
          <div class="payment-icon">
            <i class="fab fa-cc-visa"></i>
          </div>
          <div class="payment-icon">
            <i class="fab fa-cc-mastercard"></i>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- FAQ Section -->
  <section class="faq-section">
    <div class="container">
      <div class="section-header">
        <h2 class="section-title">Perguntas Frequentes</h2>
      </div>
      
      <div class="faq-container">
        <div class="faq-item">
          <div class="faq-question" onclick="toggleFAQ(this)">
            <span>Preciso jogar com mais pessoas ou posso jogar sozinho?</span>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>
              O jogo foi projetado para ser jogado tanto individualmente quanto em grupo (1-8 jogadores). 
              A experiência em grupo tende a ser mais dinâmica com discussões e teorias, mas jogar 
              sozinho também é muito imersivo e desafiador.
            </p>
          </div>
        </div>
        
        <div class="faq-item">
          <div class="faq-question" onclick="toggleFAQ(this)">
            <span>Como funciona o 'Prazo de Garantia'?</span>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>
              Você tem 7 dias de garantia após a compra. Se por qualquer motivo não ficar satisfeito 
              com o produto, basta solicitar o reembolso e devolveremos 100% do valor pago.
            </p>
          </div>
        </div>
        
        <div class="faq-item">
          <div class="faq-question" onclick="toggleFAQ(this)">
            <span>Os casos são realmente desafiadores?</span>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>
              Sim! Cada caso foi cuidadosamente elaborado com múltiplas camadas de mistério. 
              As pistas são interconectadas e exigem atenção aos detalhes, análise crítica e 
              trabalho em equipe para serem desvendadas.
            </p>
          </div>
        </div>
        
        <div class="faq-item">
          <div class="faq-question" onclick="toggleFAQ(this)">
            <span>Como acessar o produto?</span>
            <i class="fas fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            <p>
              Após a confirmação do pagamento, você receberá um e-mail com o link de acesso 
              à plataforma onde poderá baixar todos os materiais em PDF. O acesso é vitalício 
              e você pode baixar quantas vezes quiser.
            </p>
          </div>
        </div>
        
        <div style="display: flex; justify-content: center; align-items: center; margin-top: 50px; width: 100%; text-align: center;">
          <a href="#comprar" class="btn btn-primary btn-large">
            <i class="fas fa-shopping-cart"></i>
            Garantir minha cópia agora
          </a>
        </div>
      </div>
    </div>
  </section>

  <!-- Footer -->
  <footer class="footer">
    <div class="container">
      <div class="footer-logo">Mistério de Ravenwood</div>
      
      <div class="footer-links">
        <a href="#">Termos de Uso</a>
        <a href="#">Política de Privacidade</a>
        <a href="#">Contato</a>
        <a href="#">FAQ</a>
      </div>
      
      <div class="footer-social">
        <a href="#" class="social-link">
          <i class="fab fa-instagram"></i>
        </a>
        <a href="#" class="social-link">
          <i class="fab fa-facebook"></i>
        </a>
      </div>
      
      <div class="footer-bottom">
        <p>&copy; 2025 Duo Games. Todos os direitos reservados.</p>
        <p>Feito com ❤️ para amantes de mistérios</p>
      </div>
    </div>
  </footer>

  <!-- Float Buttons -->
  <div class="float-buttons">
    <button class="float-btn scroll-top-btn" id="scrollTopBtn" onclick="scrollToTop()">
      <i class="fas fa-arrow-up"></i>
    </button>
  </div>

  <script>
    // Scroll to Top Button
    window.addEventListener('scroll', function() {
      const scrollTopBtn = document.getElementById('scrollTopBtn');
      if (window.pageYOffset > 300) {
        scrollTopBtn.classList.add('visible');
      } else {
        scrollTopBtn.classList.remove('visible');
      }
    });

    // Smooth scroll
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function(e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
          target.scrollIntoView({
            behavior: 'smooth',
            block: 'start'
          });
        }
      });
    });

    // Scroll to top
    function scrollToTop() {
      window.scrollTo({
        top: 0,
        behavior: 'smooth'
      });
    }

    // FAQ Toggle
    function toggleFAQ(element) {
      const faqItem = element.parentElement;
      faqItem.classList.toggle('active');
    }

    // Carrossel mobile melhorado
    let currentSlideIndex = 0;
    const totalSlides = 2;

    function moveCarousel(direction) {
      const track = document.getElementById('carouselTrack');
      if (!track) return;
      
      currentSlideIndex += direction;
      
      // Loop infinito
      if (currentSlideIndex >= totalSlides) currentSlideIndex = 0;
      if (currentSlideIndex < 0) currentSlideIndex = totalSlides - 1;
      
      // Move o track (50% por slide, pois cada slide é 50% do track)
      const translateX = currentSlideIndex * -50;
      track.style.transform = `translateX(${translateX}%)`;
      
      updateCarouselDots();
    }

    function goToSlide(slideIndex) {
      const track = document.getElementById('carouselTrack');
      if (!track) return;
      
      currentSlideIndex = slideIndex;
      const translateX = currentSlideIndex * -50;
      track.style.transform = `translateX(${translateX}%)`;
      
      updateCarouselDots();
    }

    function updateCarouselDots() {
      const dots = document.querySelectorAll('.carousel-dot');
      dots.forEach((dot, index) => {
        dot.classList.toggle('active', index === currentSlideIndex);
      });
    }

    // Inicializa o carrossel quando a página carrega
    document.addEventListener('DOMContentLoaded', function() {
      updateCarouselDots();
    });



    // Animate on Scroll
    const observerOptions = {
      threshold: 0.1,
      rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.style.opacity = '1';
          entry.target.style.transform = 'translateY(0)';
        }
      });
    }, observerOptions);

    // Observe elements
    document.querySelectorAll('.material-card, .testimonial-card, .how-card').forEach(el => {
      el.style.opacity = '0';
      el.style.transform = 'translateY(20px)';
      el.style.transition = 'all 0.6s ease';
      observer.observe(el);
    });
      </script>
  </body>
  </html>